Standing at the end of a country road, the sun is setting over my shoulder as I stare down into the shallow river valley. It is a typically Cheshire scene, with wide open grassy fields enclosed by trimmed hawthorn hedges and overlooked by old heavily leafed oaks. The atmosphere should be undisturbed as the light falls on a warm sunny day but the railway over the crest interferes with the senses, with the distant rumble of freight trains and the higher pitched passing of inter-city expresses. Above human sounds, the birds come through; there are chiffchaffs well past their spring prime, great tits irritated in a nearby tree, swallows gathering the last insects of the day, blackbirds calling their dusk alarm and the ubiquitous rural crow slowly paddling and calling its way though the cooling air. Hidden away at the bottom of the gradually sloping fields runs a narrow river, enclosed by woodland on one side and by wheat and maize fields on the other. As the light continues to dim, the daytime wildlife settles down, while their nocturnal counterparts start to stir and emerge out to feed. This is a time of badgers, foxes and owls, but tonight it is the bats that will reveal their world.
I don’t normally find myself heading out into the countryside at sunset on a weekday, but this week I had a very good reason to. My conservation volunteering colleagues and friends, Wendy and Gerry, undertake bat surveys at a number of locations around Cheshire and last year I was luckily enough to be invited to join them on a couple of their survey evenings. After enjoying the experience so much last year, I hinted, not too subtlety, that I would like to join them again and this week the first opportunity for this year came my way.
This survey focusses on Daubenton’s bat activity on a one kilometre stretch of river bank, with survey points every 100 metres. Using bat detectors, torches, a stop watch and midge repellent, the number of passes made by Daubenton’s bats over a four minute period are recorded at each point. The data generated enables the Bat Conservation Trust to understand the intensity of feeding and identify any trends in population levels.
The survey site is at the end of a long farm track, just north of Church Minshull, and the River Weaver is the focus. The section of river has open fields on one side, where we survey from, and woodland on the other. We crossed the river from where we parked and had to battle our way along rows of maize before breaking out onto a freshly harvested wheat field, the stubble crunched beneath our feet as we walked to the first survey point. Starting at the far end of the survey site, we stood next to a water pumping building waiting for the right time after sunset to start the survey. The first four-minutes revealed very few bats, Daubenton’s or others, so a little disappointed we made our way to the next points.
This particular evening was warm, dry and clear but as the survey progressed the air started to cool, the dew formed on the grass and the clouds began to appear. As we wandered from point to point, the moon appeared, breaking through the haze, casting our shadows across the field. Herons flew off from the riverside and tawny owls called from inside the woodland. At times we had to scramble down the banks to the water’s edge, whilst at other points we stood high up where the banks had been cut sheer by the passing river. The midges became an increasing annoyance as we made our way along the field and into the maize, where some of the survey points are located, but they were not as aggressive as they were when I went camping in Wales a couple of weeks ago.
Our disappointment at the first survey point was soon forgotten as we recorded 127 Daubenton’s passes at one location; by far the most I have seen (last year 55 was the highest record at a single survey point). However, there were more than just the low flying Daubenton’s in the air, with Pipistrelle, Noctule and possibly Brandt’s bats flitting and speeding around our heads, some making very close passes. Overall, we recorded a good number of bats over the course of the survey but will have to wait until the second of the two visits to see how this year’s numbers compare to those previously recorded.
As we finished the survey and wandered back to the cars, I did a quick scan with the powerful torch, across the surrounding fields, to see if I could pick up any eye-shine from wandering wildlife in the night but didn’t see any. However, Wendy and Gerry did see a brown hare running along the road on the way home – a rare sight nowadays and I missed it unfortunately.
Whilst I have found these batty evenings in the middle of the Cheshire countryside truly enchanting, what I’ve really taken from these experiences is the thought that the bats are out there every night, doing what they do, not caring about the manmade world that surrounds them. Not seeing them every night doesn’t stop them being there, going about their nocturnal ways. It’s a bit like the feeling I got from the first time I wandered around a wolf territory in Sweden; I didn’t see or even hear any wolves but the mere fact that they were out there, somewhere, was enough to make me feel there was something truly wild and untamed around me, something man cannot touch. Unfortunately that feeling is just that, a feeling, as, in reality, man is touching, destroying, the wildness around us. I say wildness as there is already no wilderness at all on this island but when you look closely enough, wildness is certainly there, everywhere – from deer in the woods, bats above the rivers, to spiders in the grass and lichen on the rocks.