NAME
IO::All::LWP - IO::All interface to LWP
SYNOPSIS
use IO::All; "hello world\n" > io(''); # save to FTP $content < io(''); # GET webpage io('') > io('index.html'); # save webpage
DESCRIPTION
This module acts as glue between IO::All and LWP, so that files can be read and written through the network using the convenient IO:All interface. Note that this module is not
used directly: you just use IO::All, which knows when to autoload IO::All::HTTP, IO::All::HTTPS, IO::All::FTP, or IO::All::Gopher, which implement the specific protocols based on IO::All::LWP.
EXECUTION MODEL
GET requests. When the IO::All object is opened, the URI is fetched and stored by the object in an internal file handle. It can then be accessed like any other file via the IO::All methods and operators, it can be tied, etc.
PUT requests. When the IO::All object is opened, an internal file handle is created. It is possible to that file handle using the various IO::All methods and operators, it can be tied, etc. If $io->put is not called explicitly, when the IO::All object is closed, either explicitly via $io->close or automatically upon destruction, the actual PUT request is made.
The bad news is that the whole file is stored in memory after getting it or before putting it. This may cause problems if you are dealing with multi-gigabyte files!
METHODS
The simplest way of doing things is via the overloaded operators > and <, as shown in the SYNOPSIS. These take care of automatically opening and closing the files and connections as needed. However, various methods are available to provide a finer degree of control.
This is a subclass of IO::All. In addition to the inherited methods, the following methods are available:
ua
Set or get the user agent object (LWP::UserAgent or a subclass). If called with a list, the list is passed to LWP::UserAgent->new. If called with an object, the object is used directly as the user agent. Note that there is a default user agent if no user agent is specified.
uri
Set or get the URI. It can take either a URI object or a string, and it returns an URI object. Note that calling this method overrides the user and password fields, because URIs can contain authentication information.
user
Set or get the user name for authentication. Note that the user name (and the password) can also be set as part of the URL, as in "".
Set or get the password for authentication. Note that the password can also be set as part of the URL, as discussed above.
get
GET the current URI using LWP. Or, if called with an HTTP::Request object as a parameter, it does that request instead. It returns the HTTP::Response object.
put
PUT to the current URI using LWP. If called with an HTTP::Request object, it does that request instead. If called with a scalar, it PUTs that as the content to the current URI, instead of the current accumulated content.
response
Return the HTTP::Response object.
request
Does an LWP request. It requires an HTTP::Request object as a parameter. Returns an HTTP::Response object.
open
Overrides the
openmethod from IO::All. It takes care of GETting the content, or of setting up the internal buffer for PUTting. Just like the
openmethod from IO::All, it can take a mode: '<' for GET and '>' for PUT.
Overrides the
closemethod from IO::All. It takes care of PUTting the content.
DEPENDENCIES
This module uses LWP for all the heavy lifting. It also requires perl-5.8.0 or a more recent version.
SEE ALSO
IO::All, LWP, IO::All::HTTP, IO::All::FTP.
AUTHORS
Ivan Tubert-Brohman <itub@cpan.org> and Brian Ingerson <ingy@cpan.org>
Thanks to Sergey Gleizer for the ua method.
Copyright (c) 2007. Ivan Tubert-Brohman and Brian Ingerson. All rights reserved.
This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.
See