N° 35, 2016 - Entrepreneurship: Which way for the development of Haiti
PlanHaut de page
Entrepreneurship: Which way for the development of Haiti
Entrepreneurship is a well researched topic that covers Small and Medium Enterprises (SMEs), corporate, developed countries, under developed countries and developing countries. This special issue is about entrepreneurship in Haiti which according to a Financial Times (2015) report is the Latin American country with the greatest number of locals opening their own business each year and yet the country where there is the least financial support for entrepreneurs. This paradox could be due to a need for locals to survive, it could also be a cultural factor; a strong belief that entrepreneurship can improve the economic development of Haiti, etc.
Academic research in the field of entrepreneurship in undeveloped countries show that locals are deeply interested in creating their own businesses because it is the only option for them to make a living and meet their primary needs (Séraphin, 2012 ; Mshenga & Owuor, 2009). Books about Haiti support this point. In Laura Rose Wagner’s book ‘Hold tight don’t let go’ (2015), Magdalie, the main character opened her business of selling water right after the January 12, 2010 earthquake. The only purpose was to make a living. In ‘Bonjour blanc a journey through Haiti’, Ian Thomson (2014, 2004) explains how Richard Morse became an entrepreneur in the hospitality sector by chance (Séraphin, 2014, 2013).
In Haiti, nothing seems to be planned in advance. Everything seems to happen by chance, hence the reason why entrepreneurship is a heavy weight in the GDP of the country (Financial Times, 2015). This non strategic and short term vision of entrepreneurship in Haiti is peculiar to the vast majority of the population, that is to say the poor. However, this does not happen across the board as the rich (the minority of population) also called the ‘elite’ have a perception of entrepreneurship similar to developed countries where entrepreneurship is seen as a long term strategy with so called Corporate Social Responsibilities (CSR).
This special issue about Haiti is to find practical solutions to ensure that entrepreneurship can play a major role in the economic development of the country. Jerry Tardieu, a Haitian entrepreneur, claimed that investing in Haiti is a proof of faith in the country’s potential. What can be done to turn entrepreneurship into a sustainable tool for the development of Haiti? This is the central research question of this special issue.
For a while, leading entrepreneurs in Haiti were from the Middle East (Syria, Liban, etc) and public companies. However, over the last three years, entrepreneurs in Haiti have come from different backgrounds. Also, more and more young people are getting into entrepreneurship and many public companies have been privatised. Despite the fact that for some analyst’s entrepreneurship in Haiti has totally failed (Lundahl, 2010), the development of micro finance over the last few years has democratized access to funding, enabling development of a multitude of micro-enterprises (Paul & Dameus Garrabé, 2011) (Paul, Daméus & Garrabé, 2011).
With programmes like ‘Mon Entreprise Mon Avenir’ or programmes for young entrepreneurs (public sector) and Digicel Entrepreneur of the Year (private sector), how are the locals responding to this financial support? How are all these changes impacting on the economic development of the country? Despite the different initiatives to develop entrepreneurship, there is still a dearth of financial support for locals. How can entrepreneurs be supported? What sectors have an edge? Is the fact that public and private sectors are keen to develop entrepreneurship going to turn the ‘informal’ entrepreneurship sector in Haiti into a ‘formal’ entrepreneurship sector?
This special issue is going to consider conceptual and empirical papers. Even if this special issue is about Haiti, destinations with a similar profile will also be considered (Latin American countries, Haiti, etc). In this issue, multi disciplinary approaches will also be considered (management sociology, geography, ethnology, anthropology, politics, etc)
Key themes
The link between entrepreneurship and economic development
Entrepreneurship and territorial development. How to move from ‘the Port-au-Prince Republic’ to a more decentralised development?
Entrepreneurship strategy in a poor country context / scarce availability of financial support
Public sector policy and entrepreneurship schemes
Co development of entrepreneurship and financial systems
Recent changes in the entrepreneurship system of Haiti
The relation between commercial entrepreneurship and productive entrepreneurship
Recent investments in tourism
Recent governemnt policy for the development of entrepreneurship
Entrepreneurship and immaterial resources (cultural, artisanal, symbolic, etc.)
Entrepreneurship and a variety of projects (women, youth, students, seniors, disabled, etc.)
Entrepreneurship and the working class: Can poor people be considered entrepreneurs?
The link between entrepreneurship and education
The legal vacuum limiting the development of agricultural entrepreneurship
Papers in English and Spanish are welcomed
Deadlines
July 15th, 2015: Abstract (500 words)
February 29th, 2016: Full paper
May 20th, 2016: Reviewed paper
July, 2016: Publication of the paper
Guest editors
Hugues SERAPHIN (The University of Winchester, Angleterre)
Bénédique PAUL (Université Quisqueya et Université d’Etat Haïti)
Papers should be sent to
hugueser.tourism@gmail.com et benedique.paul@uniq.edu.ht