Honduran democracy on the brink
With no declared winner two weeks after election, the legitimacy of the Honduran democracy is hanging in the balance.
Published On 11 Dec 2017
Two weeks after incumbent president Juan Orlando Hernandez appeared to lose an election he was expected to win handily, Honduras is teetering on the edge of chaos. The day after the election, opposition candidate Salvador Nasralla was ahead by five points with 58 percent of the vote counted, a margin an electoral tribunal member described as irreversible. Then, the tally was mysteriously stopped for more than a day. Soon after it resumed, Hernandez inexplicably pulled ahead with the slimmest of leads, sparking massive protests.
No winner has been declared, and the opposition has filed a legal challenge to the tabulation process. The extreme electoral irregularities and the charged context in which they arose are threatening to inflame instability for years to come.
Nearly two-thirds of Hondurans live in endemic poverty and pervasive violence, conditions that have fueled the migrant crisis that US President Donald Trump so frequently rails against. Beleaguered but unbowed, they have courageously taken to the streets in spirited demands for a transparent and fair election process . Hernandez responded to the uprising with a violent crackdown, a curfew and a suspension of constitutional rights that has left at least fourteen people dead and hundreds detained, with some of the repression stemming from US-trained security forces. Some of the restrictions have since been lifted, but the situation remains tense amid a deteriorating human rights climate, and the specter of state-sponsored violence remains omnipresent.
Although he has consolidated power in the military, legislature, judiciary and the electoral authority since his election in 2013, Hernandez was apparently hedging his bets. Perhaps that’s because the majority of Hondurans oppose presidential re-election, which is banned by the Constitution..
On November 25, The Economist disclosed a purported recording of his “Plan B”, a pre-election National Party training session providing coaching on how to rig the election. Credible evidence and a detailed analysis by Economist strongly suggest that those efforts escalated after Hernandez was caught off guard by Nasralla’s surging vote count.
That Hernandez would refuse to relinquish an office he was illegitimately seeking is hardly a surprise. Ironically, the prohibition against a second term served as the spurious justification for the ouster of left-leaning President Manual Zelaya in 2009, a move Hernandez supported. The ban on re-election was lifted in 2015 by a Supreme Court that Hernandez had stacked in his favour, undermining the rule of law. Now, the country is on the cusp of a haunting reprise of the coup that unleashed an unprecedented wave of violence and misery.
Wary of Zelaya and his geostrategic impact in the region, Washington helped legitimise the post-coup government that set in motion the fraught conditions for this contested election. Since then, the United States has provided $114 million in security aid and unwavering support to Honduras, turning a blind eye to the deeply embedded institutional corruption. The National Party’s theft of hundreds of millions of dollars from the national health service – some of which filled the incumbent’s election coffers – triggered indignant torch-lit protests in 2015, but accountability for that graft has been elusive. Despite a reported drop in the sky-high murder rate attributed to Hernandez’s iron-fist policies, a palpable climate of fear and intimidation has spread far beyond the groups targeted for repression – human rights defenders , journalists, lawyers, opposition activists, members of the LGBTI community and others – to the broader population. Meanwhile, Honduras has opened its borders to transnational investors eager to exploit the country’s desperate need for development. Yet little benefit has trickled down to the nation’s impoverished masses , according to an analysis of social and economic indicators by the Center for Economic and Policy Research.
Still, in September, well before the election, Secretary of State Rex Tillerson cheered the two countries’ “joint efforts to strengthen democratic institutions in the region.” But instead of signaling that there would be fallout from the flagrant erosion of democratic principles, two days after the contested election Tillerson certified that Honduras complied with conditions requiring progress on anti-corruption efforts and human rights protections for the release of millions of dollars in US aid.
The decision came just weeks after an explosive report implicated state security forces in the conspiracy to assassinate internationally acclaimed indigenous and environmental activist Berta Caceres in 2016 and in covering up the crime and shielding its masterminds. The optics and timing of the State Department’s vote of confidence are abysmal, though Congress can mitigate the harm by exercising its power to withhold funds despite the certification.
Election observation teams from the Organisation of American States (OAS) (pdf) and the European Union (EU) have roundly criticised the flawed process. A growing chorus both inside and outside of Honduras is echoing those grave concerns, including US lawmakers Senator Patrick Leahy,ranking member of the Senate Foreign Relations Committee Senator Ben Cardin, the Congressional Progressive Caucus, and many others. Yet the US Embassy in Honduras released a statement on December 4 commending the government’s transparency and citizen participation in the process. The embassy later bowed to pressure by supporting the OAS and EU positions and a partial recount, but Washington’s vested interest in propping up its man in Honduras is abundantly clear.
The parties remain at an impasse. The opposition alliance has called for a vote-by-vote recount of all ballots under international supervision, based on its justifiable suspicion that the tally sheets have been tampered with and the database itself compromised. The demand for a full and transparent recount is eminently reasonable considering the myriad irregularities that have tainted the election and the National Party’s control of the state apparatus overseeing it. In contrast, the electoral authority and Hernandez have agreed only to a partial recount of the votes that arrived after the pause, but without important safeguards that would ensure the recount’s integrity. Failing a complete recount, a new election conducted with close and impartial international oversight will likely be necessary to restore the credibility of the democratic process.. President Trump’s angst at losing the popular vote last year drove him to create a government commission to ferret out voter fraud despite the complete lack of evidence that any occurred. The least he can do for Honduras is to withhold economic and political support until the electoral process produces a fair and transparent outcome, no matter how long that takes. The legitimacy of the Honduran democracy is hanging in the balance.
The views expressed in this article are the authors’ own and do not necessarily reflect Al Jazeera’s editorial policy.