The OpenSSL Project is warning today about six new weaknesses in the open source implementation of the Secure Socket Layer (SSL) encryption protocol that could be used by attackers to intercept SSL traffic and view encrypted information.
In its first advisory since it repaired the dangerous and widespread Heartbleed vulnerability, the organization said at least one of the software errors could enable criminals to conduct man-in-the-middle attacks to eavesdrop on protected traffic between vulnerable clients and servers.
Both the server and client must be using a vulnerable version of OpenSSL in order for an attack to succeed, according to the advisory. All OpenSSL clients are vulnerable, the organization said. OpenSSL servers are vulnerable in OpenSSL 1.0.1 and 1.0.2-beta1.
[Related: Five Essential Facts About Heartbleed And OpenSSL]
The vulnerability could impact users of Android who use the Chrome browser, which supports OpenSSL, said Ivan Ristic, director of engineering at vulnerability management vendor Qualys. The risk of being attacked is low, Ristic said, because most browsers don't rely on OpenSSL and the attacker would need both the client and server containing the vulnerability. Ristic estimates that roughly 24 percent of servers in Qualys' database are running a vulnerable server.
"On the surface, the fact that the vulnerability requires man-in-the-middle positioning for exploitation is limiting, but as better tools are developed, automation might enable easy mass exploitation on Wi-Fi networks and similar environments," Ristic said in his analysis.
The organization fixed a bug reported in March that could crash OpenSSL TLS clients that enable a protocol used in mobile or wireless environments called ECDH Cipher Suites. Two other errors also were addressed but are not enabled by default and impact uncommon implementations, according to the advisory.
The latest round of repairs from the OpenSSL Project prompted Red Hat, Ubuntu and FreeBSD to issue advisories to users today. The update to Red Hat Enterprise Linux 6 is rated "Important" by the software maker's security response team.
The OpenSSL Project gained widespread attention from the public following its advisory in April that repaired the Heartbleed vulnerability. The open source encryption protocol is supported in application servers that enable popular online services. The threat prompted Facebook, Dropbox, Google and others to recommend users change their passwords.
Experts are increasingly focusing on open source initiatives prompted by the global impact of the Heartbleed bug. The dangerous flaw publicly demonstrated how open source code is embedded in millions of widely used commercial and open source products.
Solution providers said attention to software vulnerabilities in widely used products is a serious concern.
Skip Gould, CEO, BrightPlanIT, a Buffalo, N.Y.-based systems integrator, said his firm worked with clients impacted by Heartbleed and found many organizations had to be educated about how to appropriately address the threat. Despite no reported security incidents associated with the flaw, Gould and other IT industry experts told CRN that the risk posed by the flaw was serious and not overblown.
"I'd much rather have these kinds of issues overcommunicated than having people be blindsided by problems," Gould said. "Even if someone is backseat driving, I'd rather know about a serious issue twice or three times than not know at all."
OpenSSL is supported in a variety of software applications, application servers and networking gear, including VPNs and security appliances. As technology vendors raced to issue software updates to vulnerable systems, IT teams were forced to conduct a thorough check for devices that support the vulnerable protocol.
Mandiant, the services arm of FireEye, uncovered a technique that could be used to bypass multifactor authentication on VPN sessions.
The fallout from the single security vulnerability prompted a $3.6 million donation to the Linux Foundation from an initial consortium of technology firms, including Amazon Web Services, Cisco Systems, Dell, Facebook, Fujitsu, Google, IBM, Intel, Microsoft, NetApp, Rackspace and VMware.
The companies each pledged to make a $100,000 payment over the next three years and said the funds would start by bolstering support for those that voluntarily maintain the OpenSSL Project.
The funding was heralded by open source advocates. In previous years, the OpenSSL project had received about $2,000 per year in donations for support.
PUBLISHED JUNE 5, 2014