An experimental vaccine for brain cancer has shown promising results in preliminary investigations at UCLA’s Jonsson Cancer Center. The results are published in this week’s issue of the peer-reviewed journal Cancer Research.
The vaccine, studied first as a preventive strategy for brain tumors, completely prevented brain tumor formation in laboratory rats. In contrast, all of the rats that did not receive the vaccine developed very aggressive brain tumors.
“The results of our study are very encouraging. The 100 percent protection is pretty dramatic,” said Dr. Linda Liau, a brain cancer surgeon, researcher at UCLA’s Jonsson Cancer Center and lead author of the journal article. “However, we don’t yet have ways to determine who is at high risk of developing brain tumors. So our next step is to begin preliminary testing of this vaccine as a possible treatment strategy for brain tumors.”
There is a critical need for more effective therapies for brain cancer, which affects more than 17,000 Americans each year and is almost 100 percent fatal, Liau said. Malignant gliomas are the most deadly type of cancerous brain tumor.
“Without any treatment, patients with the most aggressive gliomas usually do not live longer than nine months. Even after surgery, radiation and chemotherapy, patients usually live only for as long as two years,” said Liau, who also is an assistant professor of neurosurgery at the UCLA School of Medicine.
While the vaccine research shows promise, it will be several years before human testing may begin, Liau said.
The vaccine is designed to boost the immune system’s response against brain cancer by exposing the antigens, or specific proteins, that brain tumors produce. Each tumor produces several antigens that may be recognized by the immune system.
Although the immune system can identify and attack bacteria, viruses and tumors, it does not recognize all brain tumor antigens.
When the immune system does not detect these antigens, it can mistake the insidious cancer cells for normal cells and ignore the cancer cells instead of attacking them.
But when the immune system has a way to recognize the antigens, the cancer cells are vulnerable to immune attack.
To make the vaccine, researchers used an antigen known to be recognized by the immune system. The antigen was partnered with a common form of bacteria, called Listeria monocytogenes, which UCLA scientist Jeffrey Miller engineered to be harmless. The bacteria essentially served as a transportation mechanism for the antigens.
“The immune system already is primed to fight bacteria. So by using specially engineered bacteria to transport the antigens, we drew the immune system’s attention to the bacteria. In doing so, we also drew its attention to the tumor antigens,” Liau said. “And with its attention focused on the antigens, the immune system learned to recognize and attack the cancer cells that produced those antigens.”
One drawback of vaccine therapy is that every brain tumor produces different kinds of antigens, so it is impossible to know up front which antigens should be incorporated into a vaccine.
But Liau said vaccine therapy might stimulate the immune system to remain on the warpath, even after the immune system has hunted down cancer cells that produce the antigens present in a particular vaccine.
“When we engineer bacteria to carry around a certain kind of antigen, the immune system learns to recognize that antigen and attack the cells that produce it. In doing so, the immune system can become a better detective and will start to recognize and attack brain tumor cells with other kinds of antigens,” Liau said.
UCLA scientists now are working to improve the vaccine by developing a form of the Listeria bacteria that is safe for use in humans.
Liau is optimistic that targeted approaches to treating brain cancer may hold the key to improving survival and enhancing quality of life in patients.
“We desperately need treatment options for inoperable brain tumors and for the cancer cells that get left behind when we can’t surgically remove an entire tumor,” she said. “I suspect that the body’s immune system is more intelligent than anything we could configure to recognize foreign cells or agents, and more effective than traditional treatments at leaving healthy cells alone.”
Story Source:
The above story is based on materials provided by University Of California - Los Angeles. Note: Materials may be edited for content and length.
Cite This Page: