On June 9, 15 current and retired University of Wisconsin Oshkosh College of Business (COB) faculty traveled to China for two weeks to learn more about Chinese business education and practice.
The trip was financed through fundraising efforts and out-of-pocket by the individual professors.
Making stops in Beijing, Hangzhou, Ninghai and Shanghai, the faculty focused on local Wisconsin companies that are doing business in China, including Godfrey & Kahn, Kohler, Oshkosh Corp. and Traffic Cast.
“By visiting a variety of cities, we had the opportunity to view the phenomenal growth of monster coastal cities, such as Shanghai, and the continuation of traditional methods of farming and life in more rural areas, such as Ninghai,” said Marianne Johnson, UW Oshkosh associate economics professor.
“We also had an opportunity to see Beijing’s preparation for the Olympics in August, including their famous Bird’s Nest Stadium, to be used for opening ceremonies, and the Water Cube,” she said.
Higher education
The faculty visited two universities in Shanghai: the China-Europe International Business School (CEIBS) and Shanghai University. CEIBS is a private university that offers only graduate study in business, with an MBA and executive MBA (EMBA), as well as certificate programs. Both are ranked in the top 10 internationally for their business programs and have a number of impressive facilities, including a finance center that provides top-level consulting, research and workshops for the Chinese government and Chinese businesses.
CEIBS is seeking accreditation from the Association to Advance Collegiate Schools of Business (AACSB), a move that will place more limits on its structure and actions but which, the administration feels, is necessary to recruit faculty and students internationally. UW Oshkosh is the only AACSB-accredited university in northeastern Wisconsin.
The University of Shanghai, a public university that primarily serves local students, offers semester-long and summer study programs taught in English for business students.
One of the major problems facing the Chinese education system is that there are more Chinese students seeking admission to universities than there are spots available. Just prior to the faculty’s arrival, Hangzhou Foreign Language School (HFLS), an elite public high school, held its college entrance exam. The exams determine whether a student can seek admittance to a university as well as what level of university.
UW Oshkosh’s College of Business hopes to pursue a cooperative agreement with HFLS to guarantee admittance of five students per year to UW Oshkosh’s business program.
Business and industry
The faculty visited a number of different types of businesses. Industrial sites included a Chinese-owned textile factory; the Chinese-American-owned company PacRim that produces metal stamping and injection molding and a Kohler plant that produces faucets for the Chinese market.
“One characteristic of all these factories was what is called ‘Chinese-style’ automation, a mix of technological and labor intensive production,” Johnson said.
Nancy Sun, PacRim CEO and president, estimated that by 2012, the Chinese comparative advantage in cheap labor will disappear and costs of production in China and Mexico will be roughly equivalent.
PacRim is considering two strategies in anticipation of the cost shifts: opening a plant in Mexico for supplying U.S. companies as well as shifting production to more sophisticated and specialized parts for green technologies.
Another characteristic of the companies’ officers was a concern over rising input prices, including higher labor costs due to a new Chinese labor law requiring companies to provide a range of insurances for workers, higher commodity prices and higher energy prices.
“We also learned that there are significant differences in government and tax treatment of Chinese-owned, joint-venture and wholly foreign-owned companies,” Johnson said. “For those thinking of producing in China, negotiating government bureaucracy, labor laws, environmental laws and so forth can be very difficult, and there are advantages and disadvantages of each type of ownership structure that bear careful investigation.”
In addition to factories, the faculty toured several service-provision organizations, including Wisconsin law firm Godfrey & Kahn, Nielson Market Research and Traffic Cast. Representatives of all three companies emphasized several shared themes: the rise of the Chinese middle class and of discretionary consumption and the vast differences in regional preferences and customs.
Nielson reported on the success of Pizza Hut and how the company addressed cultural differences between American and Chinese diners, such as the difficulty of selling salad to Chinese consumers. Traffic Cast provided evidence of the rising demand for consumer service products, including real-time traffic reports and forecasts.
Government
The visiting faculty also met with governmental and international organizations, including a Wisconsin Department of Commerce representative, an officer of the U.S. Commercial Services Office and the American Chamber of Commerce president in Beijing.
“While all were largely positive about U.S. opportunities in China, they each stressed the importance of a careful entrance strategy, whether for producing or selling in China, and cautioned us on the necessity to do very thorough background checks on potential Chinese partners,” Johnson said.
Ten years ago, most U.S. companies in China were manufacturing for the U.S. market; however, today most companies are manufacturing in China for the Chinese market — a big shift in strategy and operation, she said.
In Ninghai, the faculty had the chance to talk to Chinese governmental officials, including the mayor, deputy mayor and local Communist Party officials to learn about local politics and taxes. They also had the opportunity to talk to Oshkosh Corp. representatives about the business challenges of selling directly to the Chinese government as a wholly foreign-owned company.
While having enormous potential, China faces a number of important challenges in coming years, including dealing with inflation, reforming the Chinese educational system to encourage more creative thinking that can be leveraged into business and product innovation, and addressing environmental concerns from manufacturing and from the rapid growth in automobile usage, Johnson said.
“Other highlights of the trip included eating duck tongue, witnessing employee nap time at PacRim, climbing the Great Wall, visiting the Forbidden City, boating on beautiful West Lake as well as seeing Buddhist temples, Chinese gardens and the fantastically modern Pudong (in Shanghai),” she said.
Graphic courtesy of Google Maps.