Are animal proteins better than vegetable ones? Let’s clarify this debate that often arises when it comes to defending or attacking the vegetarian and vegan lifestyle.
Proteins are polymers made up of the union of several “bricks” called amino acids. Among the three macronutrients, proteins are those whose structural role represents the primary function, while the energetic role is secondary, unlike carbohydrates and lipids. Proteins perform hundreds of different functions in the body and their intake with the diet must be constant, as the body does not have a real protein reserve, unlike lipids and carbohydrates.
When it comes to proteins, two fundamental aspects must be considered: quantity and quality.
- Quantity: the body can obtain the amino acids it needs either from the proteins we ingest with food or by degrading the proteins present in the body, such as those that make up muscles (mechanism that explains the reduction of muscle mass during low-calorie diets);
- Quality: the body uses twenty different types of amino acids. Our body is able to synthesize only some of them while others, defined as “essential”, must be introduced exclusively with food.
It is therefore important to choose foods not only for the amount of protein they contain but also for their quality, so that it provides all the amino acids needed by the body.
Which is the best protein source: animal or vegetable? Leaving aside the ethical choice, the aspects to be analyzed are many and often cause confusion.
- If we only consider the chemical aspect, the amino acids that make up animal and vegetable proteins are identical. The difference lies in the amino acid composition of the proteins. Those of vegetable origin are penalized by the fact that they do not provide all the essential amino acids, while animal protein sources are complete in their composition and for this reason they are defined as “proteins of high biological value”.
- However, we must take into account that by eating any food we also ingest other nutrients. Red meat contains proteins of high biological value but also saturated fats and molecules that increase the risk of developing colon cancer, for example. If we ingest a plant-based food, we know that we do not bring all the essential amino acids but also fibers, polyphenols, vitamins and minerals that will have a protective effect, for example for colon cancer. So, no food has only positive aspects, but each food must be evaluated in its entirety.
- Digestibility of proteins. It is not enough for the food to contain a certain amount of protein if the body is unable to digest them and absorb all the amino acids. Proteins of animal origin have a very high digestibility while those from cereals and legumes have a digestibility of 80-90% and the other vegetable sources about 50-80% compared to animal ones. This is why the nutritional recommendations indicate a daily protein intake increased by 10% in subjects who take exclusively vegetable proteins.
To conclude, the transition to a more ‘vegetable’ dietary model does not necessarily improve the nutritional adequacy of a diet. The closer you get to a vegetarian model, the more important it is to ensure a high variety of protein sources used. While, if you opt for an omnivorous diet, it is important to carefully choose animal foods in their entirety of nutrients and try to make at least half of the proteins from plant sources.