H-EDS/JHS can be a debilitating, disabling and devastating disease for some patients. Some people can have a milder course. It is a spectrum and in my family, we are three people with this disease, but with different manifestations and degrees of severity.
Taking care from the moment of diagnosis can change a child’s future. Consult a rheumatologist who understands how serious this condition can be in some individuals. Your child’s rheumatologist also should know that instead of waiting to see what kind of course it runs in your child, it is better you get the advice and consultation of a good physiotherapist right now as a preemptive and preventive strategy.
Personal Example of difficulties a child/ teenager might face:
I had excruciating shoulder and back ache as a kid from carrying my school backpack. I had severe pain for days on after attending PE (or PT) classes on Saturdays. I had severe pain in my fingers and hand when trying to keep up with teachers writing on blackboard or dictating notes. I had severe pain in my legs in the evening making it difficult to do my homework. My school rickshaw did not turn up one day, and I walked 2 km back to home – and the leg pain lasted for days. As I grew up, I cycled 2 kilometers to school – precipitating severe leg pain and asthma everyday. I had recurrent urinary tract infections (including few episodes of cystitis) since I was ten. I was easily exhausted – fatigue is a problem in many JHS patients. I could not tolerate extreme temperatures, and low blood pressure has always been a problem. As a teenager, I started migraines. I got a subluxation of my jaw joint when I kept my mouth open too wide for too long during a dental procedure. I have recurrent gum problems in spite of good dental care since childhood. As a teenager, my wrists got severely and irreversibly damaged within a matter of two years after lifting water filled buckets daily. I have very poor proprioception (joint position sense) in my knee joints, and without looking in the mirror I have no idea if I am overextending or not. I consciously keep it microbent (flexed) a bit all the time – which has its own side effects, but it lowers the knee pain. I do forget some times, and it precipitates severe pain. I have to be mindful about my joints all the time. Small forgetful incidents where a joint is in a bad position or stressed for some time can lead to pain for weeks.
Your child might face variations of such symptoms – believe him/her and get proper help. A person with JHS must not do impact sports or high velocity sports. You will need to talk to the teachers as well to ensure they get to do beneficial PE instead of something that leads to pain and damage. Proper fitting completely flat shoes with good cushioning inside as essential. They can damage their wrists by lifting weights like bags if it is done daily or frequently. Some JHS kids also have sleep and gastrointestinal disturbances. They should stay active to stay strong, maintain stamina and avoid obesity. The child should avoid sitting in W position and doing funny tricks with weird joint contortions. They may have problems related to coordination, gait and balance that can affect their education and career choices.
It will help to consult a tertiary center of physiotherapy in some reputable hospital for your child to get help in these matters:
- Gait training for walking and standing without overextending joints (like knees for example). They will need training for core stability, core strengthening and posture. They have to learn to be conscious of their posture and what is the right posture.
- Know the specific exercises that will help them. They will indeed need to stay active and exercise daily.
- Learn that they must not go to the full extent of the stretch in any exercise- they need to stop a few cm short of the full range. If they move their limbs to the full range of movement, most likely they will overextend their joints without knowing it.
- They must not do the same activity for a long time. If they are writing, stop after half an hour, do some oral or other studies and then go back to writing. Same postures (of hands, fingers, wrists, elbows, shoulders, knees, feet, any part, any joint) for a long duration will go on damaging the ligaments.
- When they start using computers, they will need to learn how to use them without damaging their wrists and getting spinal problems.
- Swimming is considered beneficial.
The rheumatologist should inquire about and coordinate the management of other systemic (other than the musculoskeletal) manifestations the child has – dysautonomia, dyspraxia (coordination difficulties), eye problems, gastrointestinal problems, respiratory or allergy related problems, urinary problems, etc.
See these articles/websites to know more about the correct approach to managing kids with joint hypermobility syndrome:
Children’s guidelines from BritishSociety for Paediatric and Adolescent Rheumatology
Children with JHS advice sheet (excellent explanation)