European Commission Vice President, Andrus Ansip, last week announced plans to end territoriality for digital content distribution.
The proposal is that Europe becomes one market, not a bunch of separate territories, for the purposes of content sales and especially sales of digital content, including many videogames and subscription services such as Netflix.
Margrethe Vestager, Europe’s Competition Commissioner, has also flagged that the EC is poised to mount a separate inquiry covering geo-blocking of online content including TV programming and games.
The arguments for and against are complex, but the founding principles of the European Union were designed to make Europe a single market. Indeed, hark back several decades to when the organisation was first established and it was known as the European Common Market.
Many areas of European law already treat the market in that way: for example, all EC passport holders have the right of residency in any member country. Many, but not all, countries have signed up for Europe’s “single currency”, the Euro. Goods and services may be offered freely across all member states.
When it comes to content, especially digital content, there are strong arguments for and against opening up the market. The major argument for creating a single market focuses on freedom of movement – a founding plank of a united Europe’s raison d’etre. If one buys (online access to) a digital service in one territory of the allegedly single market, one should not be geo-blocked from that service in other member states.
Or, to quote Ansip: “I pay my taxes in Estonia so why, when in Brussels, can’t I watch content I bought legally?”
Ansip used a specific example of not being able to watch football games, which won him plenty of public support for his position. Much of Europe is blocked from watching the world’s most popular league, England’s Premier League, access to which has already been the subject of European court cases.
The challenge, from an industry perspective, is that while it might be relatively easy in practice to sell content or a subscription service into one region containing various member states, it’s a fast-track to chaos.
The European Film Agency Directors (EFAD), which represents European film funds and other interested parties, has come out strongly against the proposals. EFAD argues that the territoriality principle must be preserved, because it’s the basis of much financing across Europe.
The loudest voice opposing Ansip’s plans within the Commission so far has been Günther Oettinger, Commissioner for digital economy and society. Oettinger said that Europe needed to preserve its cultural diversity, and protect against serving only the interests of non-European consolidated entertainment content providers, or Hollywood.
On challenge for creators is that not all content is supplied for sale. Many public broadcasters, the BBC being the prime example in Europe, raise income locally – via a licence fee in the BBC’s case. A change in legislation would mean all of Europe could access BBC programming directly (via its iPlayer service) for free, reducing the BBC’s ability to sell its programming to other European broadcasters.
Why, the British public argues, should it pay for the BBC to create content which French, German, Italian viewers then get to watch for free?
When it comes to films (and, to a lesser degree, high-end TV) the financing is increasingly multi-national in origin. Several challenges raise their heads here. National and regional funding bodies and incentive schemes provide cash on the basis of the ability to achieve some form of return.
It’s already impossible, given Europe’s freedom of movement and labour laws, to require (let’s say) an Irish animation company working on an international co-production to employ Irish workers.
When the potential return to an investor is a financial one, which is not always the case with some incentive-schemes and culturally-driven funding pots, sales of the finished product into different European territories helps achieve financial returns.
The winners from the proposed changes would only be the biggest of players – those who operate across multiple territories, who are comfortable acquiring product for multiple territories using multiple languages. A few, such as Canal+, are European. Because only the biggest of players would play, the range of titles finding homes around Europe would diminish.
It’s ironic given that the EC Vice President Ansip is proposing to cull territoriality in response to the dominance of American product over locally-produced fare in many European countries, when the major beneficiary of such a move would be the US studios.
However, common sense is not a strong suit in Brussels. Commission Regulation No. 1677/88 specifies that cucumbers will bend no more than 10mm per 10cm of length.
For those looking to sell into European territories, at MipTV, MipCom or the Marché, there’s a risk – especially for deals spanning a number of years – that the goalposts will move and deals will need to be renegotiated or be declared void.
There may be a reluctance from buyers to acquire product for a particular European territory, when they may later find themselves in dispute with buyers who holds rights for other areas of Europe. UK industry sources SCREENZ spoke to recently at FILMART expected to see a drop in business at MipTV in April and the Marché in May.
Digital distributors into Europe are currently coming to terms with changes to business rules which now require distributors to pay GST-equivalent sales taxes in the country of residence of the buyer across Europe rather than in the territory of the seller.
The change targets major vendors based outside of Europe, such as Amazon and iTunes, but applies to anybody selling digital goods into Europe. Rather than making one GST-equivalent filing per reporting period, sellers’ compliance costs now have to cover making up to 28 separate returns to different territories.
The EC has announced that it will confirm further detail on its proposals around digital content in May, although not when in May.