TIME spoke to Dan Fabricant, who recently became the head of the Natural Product Association (NPA) after serving as director of the dietary supplement programs at the FDA. Fabricant is no newbie to the NPA, though. Prior to leaving for the federal agency in 2011, Fabricant was president of global government and scientific affairs at the NPA. We asked him about making the switch between industry and regulator, leading a $32 billion industry, and skepticism over supplements.
TIME: After three-plus years at the FDA, why did you want to go back to industry?
Fabricant: I think we did more in my three and a half years there than had ever been done in dietary supplements, so I packed a career into a short time. I started to realize there is a lot I can do outside the agency to drive some of the issues I started to deal with inside in the agency, and that we can use the leverage we have to drive those initiatives. I enjoyed the work tremendously, and I am really proud of the work at the agency. This opportunity fell out of the sky, and it wasn’t without a lot of thought, but it’s an organization I really treasure.
TIME: How do you think your experience at FDA influence your new position at the NPA?
Fabricant: I think people look at the relationship between industry and regulator as an adversarial one. Not that it can’t be, but for our industry, the primary function is the same. It’s really about making sure the consumer has access to safe products. The thing we did particularly well when I was at the agency was tie it to public health. That’s big for us at NPA as well, and I think we are really going to have to drive the points home. There needs to be an understanding of why this is so important to the agency, and we need to make communications are crystal clear. In some ways I am lucky that I speak both languages on the industry and regulator side, which I think is becoming more and more important.
TIME: What challenges are you facing as the natural product industry continues to grow?
Fabricant: Culturally, there’s a shift, and there needs to be. The industry grew out of independent health care stores, and still has that independent spirit. At the same time, as things mature and we see natural products spread out to other market places, there may be misinformation or disinformation depending on who you ask. I think it’s about building a community across all chains of distribution throughout the supply chain and making sure everyone is on board with the concepts that got us to this going. The natural movement has gone more mainstream. You go into any store now and you see a lot of natural and organic products that you may not have seen 10-15 years ago. While everyone is excited about the growth in the marketplace, we also want to make sure that information is still out there to help consumers.
TIME: What about all the incidences of products with unclaimed and undisclosed ingredients, and criticisms of poor regulation? What is the NPA’s role in this?
Fabricant: I think one of the biggest things we can do is make sure that the agency is fully funded and the resources are there. Coming out of the FDA, you look at certain structure–and the bureaucracy takes awhile to change–but certain structures are not as appropriate as they used to be to get at the heart of those problems.
One of the concerns we had while I was at the agency, and it is still a concern in the industry, are not supplements at all, but products masquerading as supplements. Tainted products that are typically found in three areas: sexual enhancement, body building, and weight loss. They contain active pharmaceutical ingredients and they are in effect, unapproved new drugs. [These manufacturers] use the supplement rubric as a mask to get at the marketplace. That taints the whole industry.
One thing I got to know at the agency very well is the bandwidth at the FDA and the Dept. of Justice to bring to court those sorts of cases. This is what people are expecting of them. That’s part of our role—to make sure the agency is properly funded and also really adequately aligned with those interests. I don’t think that’s a tough sell.
TIME: There’s also a lot of skepticism over whether Americans really need to be taking supplements at all. How do you respond to that?
Fabricant: I think it’s interesting. I think physicians by and large only get on average about 16 hours worth of nutritional education in the medical school curriculum. Sixteen hours isn’t a lot, and I think less of that is dedicated to supplements and studies on supplements. I think it’s a community we really need to address, and make sure they understand the issues. One of the first things we tell anyone when they ask what we tell our retailers and manufacturers to advise consumers, is always talk to your doctor. But I think one of the things we need to do is make sure the docs are educated as well and really have a clear grasp of what’s what. A lot of people tend to have a strong opinion on dietary supplements on one way or the other. I think taking the emotion out of the topic and just looking at the science and is the place we would like to get things to.
TIME: What supplements do you take on a daily basis?
Fabricant: I take a multivitamin, I take fish oil, and I take a probiotic.
TIME: People are very interested in probiotics. How do you determine what to take?
Fabricant: There’s a lot out there. Talk to your physician and look at the research. I take it as general support for GI health and digestion, and I like the way mine tastes—it’s a liquid product. But if you go to clinicaltrials.gov there’s research on those sorts of products that support GI health. There’s a lot of information out there. They key question with any supplement use is why. When it comes to things like multivitamins, I take a multivitamin because I don’t necessarily always have the time to eat the best, so I want to make sure I am at least getting those things we know we need. It’s not so easy to get fatty fish in the diet, so I take fish oil.
TIME: What are you looking forward to as the natural product industry continues to grow?
Fabricant: The conversations. Getting people together who were not speaking as readily in the past. This industry has more in common than it does separate. I want to get people talking.