Nottingham City Council has allocated £106,000 to ensure that a robust Cold Weather Plan is in place in Nottingham to provide support for rough sleepers from November until the end of March.
This will fund winter shelter arrangements and wider support, meaning that nobody needs to sleep rough in Nottingham this winter. These arrangements come on top of the work the council undertakes throughout the year to prevent people ending up homeless. It helps fund extra bed space at additional venues that have been identified to cope with higher demand.
There has been a national increase in homelessness, with homeless charity Shelter estimating that one in every 200 people in the country is now homeless – pointing to Government welfare cuts and lack of affordable housing as the main reasons. In Nottingham this has seen the number of people found rough sleeping on a given night going up from 35 last winter to 49 at the latest count. The number was just three in 2010.
This means people may see more people on the streets as although all are offered support, some don’t accept it, for a variety of complex reasons. Others may be beggars who are not homeless. People are urged to donate to charities which support the homeless if they want to help. The City Council has launched a campaign to assure people that measures are in place to help the homeless and to urge anyone who sees someone who needs help to contact Framework.
Over the winter every year, Nottingham City Council leads a multi-agency group, including Framework Housing Association, hostels and local churches, which aims to prevent new, repeat and entrenched rough sleeping, as well as reducing the risks to the health and well-being of those who sleep on the streets. They are identified, assessed, supported and accommodated in Nottingham or reconnected back to their local community if they are not from Nottingham. Last year, the winter arrangements helped prevent 193 people from sleeping rough.
Nottingham signed up to a No Second Night Out approach, which seeks to ensure no individual arriving on the streets for the first time will sleep out for more than one night. Nottingham’s Cold Weather Plan measures are implemented from November to March, regardless of the actual temperature or weather conditions during that period. However, in in order to safeguard health in extreme weather, extra provision will be made available this year to those who have rejected accommodation offers.
The Winter Shelter is managed by Emmanuel House in partnership with city churches and other agencies. Its primary goal is to reduce rough sleeping and risk of rough sleeping. The winter arrangements involve:
• Providing sufficient bed spaces to meet expected demand each night – prioritised in terms of reducing risk and who would benefit most, rather than on a first come first served basis
• A nurse-led team provides practical healthcare, assessment, treatment, advice and support via drop-in clinics and outreach to those who are homeless, in hostel accommodation or vulnerably housed in Nottingham. Homeless people are also signposted to drop-in clinics that are held at various venues on different days throughout the week
• A homeless prevention service works with people with drug and alcohol problems who are ‘sofa surfing’ and have the potential to end up on the streets, or are vulnerably housed and having difficulties sustaining their tenancies. The service supports people to maintain their homes, and reduce the risk of potential homelessness. Citizens Advice Housing Advice provides free, independent and impartial advice to those with housing or housing related debt issues.
• The council’s Community Protection Officers operate in the city centre and every Nottingham neighbourhood, and will identify anyone sleeping rough and help anyone at risk to access support and accommodation. On Friday and Saturday nights Street Pastors from 24 different city churches are out and about in Nottingham and are also well placed to identify anyone at risk of rough sleeping and can help with accessing accommodation and support options.
• Supported accommodation providers are asked to refresh their allocation, assessment and eviction processes to reduce the risks of an individual losing a placement and becoming street homeless. Where possible and appropriate, Nottingham City Homes are committed to prioritising and fast tracking applications from people who are assessed as at risk of rough sleeping at this time of year.
Portfolio Holder for Planning and Housing, Councillor Jane Urquhart, said: “Despite huge Government cuts, we are committed to ensuring that nobody need sleep on the streets of Nottingham. We work with Framework and other agencies all year round to prevent and address homelessness, and over the winter we always put measures in place which add further support when people need it the most – helping 193 people off the streets and into accommodation last year.
“The situation has undoubtedly got worse due to Government cuts to funding for councils and welfare cuts impacting on household incomes, as well as a lack of affordable homes. On top of our ongoing efforts to tackle homelessness, we have committed over £100,000 towards support measures over the winter period. We have also launched a campaign to assure people that measures are in place to help the homeless and to urge anyone who sees someone who needs help to contact Framework on 0800 066 5356.”
Andrew Redfern, Chief Executive of Framework, said: “The level of rough sleeping is rising across the country and sadly, Nottingham is no exception. This takes a terrible toll on those involved, especially if they already have serious health problems. We strongly support the City Council in its efforts to ensure that no-one is forced to sleep rough, especially during the winter months. The decision to implement the Plan for the whole of this period, not just the coldest nights, is especially welcome.
“A combination of circumstances have put services for homeless people under extreme pressure. So this is a time for partnership working. In this way we can avoid the worst consequences of rough sleeping for the people who find themselves resorting to it. There is a shared aim to get as many people indoors as possible, and to do so as quickly as we can.”