Government & Politics
Taking the Freedom Ride
President Lyndon B. Johnson signs the 1964 Civil Rights Act as Martin Luther King, Jr. and others look on. Credit: LBJ Library photo by Cecil Stoughton.
The Civil Rights Act was signed a half century ago, but it's still a living, breathing law for millions of people. Two American University students have certainly contemplated its legacy. Tatehona Kelly and Daniel Sweig will take part in a celebration of the 50th anniversary of the landmark law on July 2 through the U.S. Department of Education's Office for Civil Rights.
Get on the Bus
As part of this event, Kelly, Sweig, and other college students will ride a bus with some of the original Freedom Riders from Washington, D.C. to Richmond, Va. Along the way, the bus will make brief stops at several sites that symbolize the struggle for racial equality. This will include the U.S. Supreme Court, where the Brown v. Board of Education desegregation case was decided in 1954, and the Lincoln Memorial, scene of Martin Luther King Jr.'s "I Have a Dream" speech in 1963.
"I'm excited to be on the bus. I know the first leg of the trip, you sit by someone specific, and then they switch you around so you get to talk to everyone. So I'm excited to see what kind of dialogue occurs," says Kelly, a rising senior in the College of Arts and Sciences.
In 1961, the Freedom Riders bravely rode buses in the American South to challenge segregated transportation facilities. One of those activists was Dion Diamond, then a student at Howard University. More recently, he spoke to one of Kelly's AU classes, and now he's scheduled to take part in the upcoming celebration. Other Freedom Riders expected to attend include Rev. Reginald Green and Joan Trumpauer Mulholland.
"As a history major, I just love people's stories. And as a writer, I love people's stories. So I just want to know the Freedom Rider experiences, and learn about things that can be transplanted to today's work," says Kelly.
History Lessons, Family Roots
Kelly's family history is emblematic of the African-American experience in the 20th century. "My great-grandmother was 102 when she passed, and when I was growing up, she used to tell us about working in Mississippi and sharecropping," Kelly recalls. Like so many African-American families, they journeyed north during the Great Migration, eventually settling in Ohio. But, as was often the case, discrimination persisted, and both of Kelly's parents dealt with busing and segregation.
Her father's intellect helped shape her consciousness. He is a history buff, and he inspired Tatehona to learn about the nation's tumultuous past. "'Jeopardy!' was on every night, and we would sit and watch the History channel. And we talked all the time about what he experienced growing up, being born in the 1950s, and seeing all of that transition," she says.
The allure of Washington, D.C. brought her to American University. In addition to her coursework in the History Department, she's a minor in public administration and policy in the School of Public Affairs. She's also had valuable internships with the Innocence Project and the Congressional Black Caucus. She's currently writing a grant proposal for the Smithsonian's National Museum of American History. Kelly is a member of the Black Student Alliance, and she's volunteered for the DC Books to Prisons Project.
Sweig is a nontraditional student, having worked for a number of years before enrolling at Harry S Truman College in Chicago. He transferred to AU in January, and he's currently working with faculty to craft his own interdisciplinary major, "The politics and economics of criminology."
Sweig traces his interest in civil rights to his idiosyncratic family background. His father was an American Jew who roped in rodeos, while his mother was a non-Jew born in wartime Germany in 1944. They had him late in life, and Daniel was always grappling with his mixed background.
"I was cognizant of the fact that there was a lot of stress in the family regarding my father's marriage to my mom," he says. "And since I grew up in Boulder, Colorado, naturally I went to a Buddhist preschool. So if I wasn't confused already!" he jokes. "Part of my passion for civil rights is my own pursuit of my identity. So I got very interested in history at a very young age, in attempt to figure that out."
He did a congressional internship with Rep. Jan Schakowsky, D-Ill., and he's currently working with One by 1 Inc., a nonprofit focused on reducing recidivism and empowering youth.
Bill of the Century
Among other things, the Civil Rights Act of 1964 banned discrimination in hotels, restaurants, and similar public accommodations, and it encouraged the desegregation of public schools. "No single act of Congress can, by itself, eliminate discrimination and prejudice, hatred and injustice," said President Lyndon Johnson, regarding the bill he would sign. "But this bill goes further to invest the rights of man with the protection of law than any legislation in this century."
Both Kelly and Sweig applied for and were accepted to be part of this special ceremony. They're not only appreciative of the Civil Rights Act's successes, but they believe it should be enhanced to combat current inequities.
"I think it needs improvement. It's still relevant, and it needs to be fluid for today's growing issues—like the resegregating of schools and districts," Kelly opines.
"We still haven't addressed so much, in terms of predatory lending and artificial devaluation of minority communities through predatory foreclosure practices," says Sweig.
Social justice advocates believe much work needs to be done. This commemoration should offer a bridge between two generations of civil rights activists. King's impassioned speech in Memphis just before his assassination still rings true, and still offers hope: "I may not get there with you. But I want you to know tonight that we, as a people, will get to the Promised Land."