History of Gold
While gold was once closely associated with money and frequently used as currency, World War II sparked change in the developed world. At this time, the Bretton Woods system was introduced, although it ceased in 1971 in response to the United States ending its gold standard. The history of gold can therefore be broken up into two distinct periods: the Classical Gold Standard, and the newer exchange rate system.
The Classical Gold Standard
Traditionally, under the classical gold standard, each country would assign an agreed amount of gold to a fixed value of local currency. This meant that gold could be converted into currency, and vice versa, and could be imported and exported freely. It was not unusual to see gold coins and local currencies being handled interchangeably.
This system was introduced in the 1870s, and was initially used only in the UK, along with selected British colonies. Portugal became the second nation to use the Classical Gold Standard, followed by Germany. Most countries had adopted the system by 1900, with the exception of China, and some nations within Central America. It was generally agreed that the system could be paused in times of crisis, and reinstated as necessary. Overall, the system was designed to show countries were dedicated to price stability. It ceased being used in 1914, when the First World War erupted. Following the war, the Classical Gold Standard shows signs of being resurrected a couple of times but it never returned to its 1900 peak and was retired for good after the Great Depression of the 1930s.
One of the reasons the Gold Standard was so popular was its inherent simplicity – the currency of any given nation was linked to gold. International settlements were made in gold, with payments surplus balances triggering an influx of gold and deficits giving rise to an outflow.
While simple on the surface, this arrangement was more complicated in practise as it could be impacted by external influences, such as actions of the central banks raising interest rates or increasing the amount of money in circulation. Interest rates would also levy changes with (just as we see today) an increase in interest rates making borrowing more expensive but attract investment from overseas, which would in turn improve the balance of payment.
There was an expectation of course that central banks using the Gold Standard would all adhere to an understood set of rules such as maintaining fixed prices, allowing the free exchange of gold and take measures such as suspending the Standard in times of war.
While the system generally worked, not all countries followed the so called “rules of the game” at all times, with some central banks known to have manipulated the Standard to increase or decrease the cost of import and export of gold.
The Bretton Woods System
Following the end of World War II, a new system to replace the Classical Gold Standard was required. The Bretton Woods System was proposed in 1944, tying the US Dollar to gold at $35 per ounce. This was the only currency to be assigned a fixed gold value, with other currencies maintaining a variable exchange rate against the USD.
While the system looked promising to begin with thanks to its promise of stability, fixed exchange rates and capital controls, it did begin to falter in the 1960s when the $35 fixed value became unsuitable in real terms. Devaluing the Dollar against gold was an idea that was not met with mutual agreement, especially as it would have required other countries to adjust their exchange rates too. There were wider factors at play at the time, with inflation rising and the cost of gold falling, a significant US trade deficit and a discord between economic growth and gold reserves.
While the London Gold Pool, which came to be in 1961 and saw several countries pool their reserves, was successful in preventing value changes from taking place, it could not stop the launch of the two-tier system with a more flexible private market. The system ended in 1971 allowing gold to be traded freely thereafter.
Cultural Significance
The rich history of gold is also deeply rooted in cultural significance, having been admired as one of the most stunning and mesmerising of precious metals for hundreds of years. Its unique reddish-yellow colour is believed by some cultures to represent the sun, making gold one of the most popular metals for jewellery all around the world.