The tragic shootings at the Sikh temple in Oak Creek this past Sunday are the latest murders in a long series of violent acts that have occurred with disturbing frequency in recent years. Our hearts, prayers and sympathies go out to the Sikh community, the victims and their families. All of Milwaukee stands in solidarity with those who are so terribly affected by this tragedy.
In my prayers and reflections since Sunday morning, I have been struck by the seemingly increasing struggle between the culture of life and the forces of death. While social critics, psychologists and ordinary folks will debate the root cause of such terrible acts of violence, we would all agree that, in many ways, our society has become increasingly coarsened and insensitive to human dignity and the right to life.
Children experience a bombardment of violence from a very early age; what popular movie or video game does not portray multiple and grisly destruction of human life? How many children grow up in neighborhoods of random shootings, drug deals and burglaries? I watched with deep sadness the video of schoolchildren verbally abusing an older woman who was serving as a chaperone on a field trip.
In many ways, our American society has become increasingly secular, pushing the influence of religion out of the public square. This rejection of the spiritual dimension of the human community is a tremendous loss because all authentic religion is a vital force for peace, justice and concern for the marginalized. When we fail to see the grand transcendence and absolute dignity of the human person, violence, disrespect and injustice will assuredly increase. Apart from its theological dimensions, religion is a vital force for social good.
The Catholic Church embraces a remarkably consistent life ethic, condemning both abortion and capital punishment, carefully laying out the criteria for a war to be considered just, proclaiming the peace and reconciliation won for us through the cross and resurrection of Christ. Yet many people in our society see the aforementioned forms of violence as not only acceptable, but as beneficial. As long as the death of another person, whether it is a child in the womb, a prisoner on death row or an “enemy” of some sort is seen as a good thing, we are still shackled by the chains of the culture of death.
Hollywood will continue to churn out films of graphic violence and pornographic sexuality as long as they are financially lucrative. Legislators and presidents will continue to protect state-sanctioned abortion as long as they perceive it to be in their political self-interest. Inner city neighborhoods will continue to be wracked by murders and drugs as long as everyone thinks “that is not my problem.”
In other words, the culture of death will continue to flourish as long as we collectively allow it to by remaining indifferent, by feeding it our entertainment dollars, by accepting violence as normal, by not articulating and proclaiming the Gospel of Life. Peace, respect, reconciliation and justice are hard work and can only be sustained by a proper understanding of the human person as worthy of absolute respect, as the proper end of all human activity. All violence, scape-goating and victimization end in the cross of Jesus Christ. By surrendering himself to death, the Son of God subverts all forms of human manipulation, the using of another for one’s own selfish gain. Where the culture of death takes the life of another for some perceived gain, Jesus offers his life, so that we can all gain together the saving love of God and the reconciliation of a world redeemed.
The Gospel of Life offers us a breath-taking vision of human flourishing, solidly rooted in the proper understanding of the person, created in the image and likeness of God, redeemed by the Son and sanctified in the Holy Spirit. We pray for the many victims of violence and we commit ourselves to the culture of life.