In vitro meat: Can we stomach it?
In vitro meat, also referred to as cultured meat, is a meat product grown from extracted cells in a factory. It's a test concept introduced by researchers to combat many ethical issues found in today's industrial livestock operations. The meat's production would also contribute to reduced environmental impacts, global hunger solutions, human health promotion and obesity reduction.\
Within the next 35 years, a process only in its beginning stages could become the norm, replacing most traditional livestock meat we find on grocery store shelves today.
Initially, it sounds like something from a futuristic science fiction novel or a dystopian society. Meat grown in a factory is straight from "The Jetsons" or "Star Trek." It's out of the question and couldn't even be possible, right? Wrong, completely wrong.
Cultured meat is happening right now. In fact, it has already happened. The first in vitro hamburger was served in 2013 in London. The two year project was highly complicated and not economically sustainable, with the final price totaling a hefty $325,000. But what did the lucky few selected to taste the burger have to say? Their biggest complaints were that the burger didn't taste the same as one that comes from grazing livestock, and it was a bit dry.
Despite the burger falling short on the taste and consistency fields, hopefuls still see the potential and are trying to obtain more funding for their research. If more support and funding is provided, the concept can become large scale, allowing the price to drop and more types of "meat" to be created.
I use the term "create," but of course I must mention that many, if not most, creationists would be completely against not only the research, but the concept itself. Many believe that growing meat goes against what is natural. Creating meat in a test tube, adding our own flavoring, vitamins and additives would be overstepping our boundaries or even "playing God." There are even people who have gone as far as saying that it would be equivalent to serving up zombies on a plate.
It's buffoonery to go as far as calling the meat "zombie production", but how can the accusation be challenged when there are companies like BiteLabs arising? The company's basis is to produce salami made of tissue samples from celebrities. Gut reaction says that this is disturbing, and, more alarmingly, cannibalistic. But is it, really?
Challenging the traditional definition of cannibalism, it is decidedly not. The production and consumption of the salami would take place between two (or more, no judgement here) consensual adults. It would also fail to violate any U.S. laws against murder or body desecration. Maybe it's skin crawling and socially unacceptable, but I wouldn't go as far as to call it cannibalism. All Sweeney Todd jokes aside, if forced to use the word cannibalism, I'd say it is a form of "humane cannibalism," if anything.
This argument presents a problem in itself, though. Since in vitro meat production is such a challenging and fairly newly researched topic there are many gray areas and questions posed that are difficult to answer because of how our society views the ideas of life, naturalism, cannibalism and humane treatment of animals. For in vitro meat to be a success, these terms must be redefined or at least understood in relation to factory grown meat.
Educational briefings and infographics would have to be readily available for the public, or they would simply not understand what it is they would be eating and would be against the meat replacement. If people aren't able to understand and accept that factory grown meat follows the same development process that meat from traditional livestock does, they will not back the introduction of the meat into the market.
Researchers behind the factory meat growing process also present the argument that in vitro meat would technically qualify as a vegan food. Part of this idea is because it would be cruelty free and a non GMO product.
The vegan-friendly argument is backed by PETA, who introduced a $1 million contest in 2008. The rules of the contest laid out that the company who was able to produce the first marketable in vitro chicken meat would receive the prize.
Unfortunately, no one was successful before the deadline arrived, and the prize money went towards combating animal cruelty in today's meat production process. PETA still considered the contest to be a raging success, though, based on the leaps and bounds made in the research and understanding of in vitro meat.
As someone who practices vegetarianism, I can see both sides of the argument. Yes, there would be cruelty-free meat available, which is a benefit that conquers a few issues vegetarians and vegans have with industrial livestock productions. It wouldn't offer a solution, though, to diehards who are not simply skipping out on meat products because they promote animal cruelty.
Some, such as Pennsylvania State University environmental resource management sophomore and environmental sustainability enthusiast Emily Newman, will not be supporting the endeavor, cruelty free or not.
When asked if she would ever find herself eating cultured meat, Newman, who has been a vegetarian for nearly two years and even practiced veganism for a brief period said, "No, definitely not. Food comes from the ground. The earth is giving it to us. We can utilize it. That's it, no need for anything to be grown in a lab."
Most vegetarians and vegans would hold the same standard. To suggest that cultured meat would be vegan friendly is to redefine the core values which people who practice a plant based diet hold themselves to.
I, however, am a big fan of the idea, not because I would find myself chowing down on some factory grown burgers or shoveling test tube bacon in my mouth, but because people who see meat as a necessity for every meal, the people who are hurting our environment and relishing in their poor health habits, will finally be able to contain their socially and environmentally poisonous behavior.
Personally, I'm still holding out for the real wave of the future- the Spy Kids' food Rehydrator, or the Star Trek Food Replicator. Until the glorious day comes when they're introduced, in vitro meat will have to do, and I'm looking forward to it's mass introduction, societal acceptance and growth within the next few decades.
Reach the columnist at mjrodr11@asu.edu or follow her on Twitter @mikayrodr.