.”
EA interferes with our endocrine system, a complex signaling network that is made up of glands (the thyroid) as well as glandular tissue and cells within organs (testes, ovaries, pancreas, etc). Our endocrine systems use hormones that send signals to our various organs and tissues that work over minutes, hours, weeks, and years. The processes these hormones regulate include metabolism, growth and development, and sexual reproduction. As hormones travel in the blood to reach each body part, the specific molecular shape of each hormone fits like a key-in-a-lock into receptors on target tissues. Endocrine disrupting chemicals may interfere with, block, or mimic the action of our hormones. As a result, EA and endocrine disruptors have been linked in hundreds of studies to brain development problems, breast and prostate cancer, birth defects, learning and behavioral problems in children, early onset of puberty, and obesity.
Manufacturers are now flaunting their “BPA free” versions of products as though they are safe and free of toxins—but it turns out BPA is possibly just the tip of the iceberg. Bisphenol S, or BPS, is another chemical that manufacturers are using to replace BPA and it may be just as harmful. In a study this year in Environmental Science and Technology, researchers, the authors found BPS present in 16 types of paper products, including thermal receipts, paper currencies, flyers, magazines, newspapers, food contact papers, airplane luggage tags, printing paper, paper towels, and toilet paper. The thermal receipt paper samples contained concentrations of BPS that were similar to the concentrations of BPA reported earlier and raised alarm for some scientists. BPS was also detected in 87 percent of currency bill samples. The authors write that several other related compounds are also used to replace BPA: bisphenol B, bisphenol F, and bisphenol AF. BPA and BPS are found in high concentrations in canned foods, BPF has been found in surface water, sewage sludge, and sediments, and BPB was found in human serum in Italy. “Limited studies have shown that BPS, BPB, and BPF possess acute toxicity, genotoxicity, and estrogenic activity, similar to BPA,” the authors write, adding that, “The environmental biodegradation rates of BPS and BPB were similar to or less than those of BPA. Although considerable controversy still surrounds the safety of BPA, the potential for human exposure to alternatives to BPA cannot be ignored.” The researchers also note that people may be absorbing BPS in much larger doses—19 times more than the BPA they absorbed when it was more widely used.
Bruce Blumberg, professor of developmental and cell biology and pharmaceutical sciences at the University of California, Irvine, wrote in an e-mail, “There are emerging data to show that BPS is an estrogen but relatively less on the other chemicals. Therefore, it is hard to say with certainty at the moment whether the BPA replacements lack estrogenic activity. BPA free means simply that—that the product is stated to be BPA free.”.”
But the FDA continues to insist that BPA is still safe. In a recent New York Times article, Michael Taylor, deputy commissioner for foods said that the agency, “has been looking hard at BPA for a long time, and based on all the evidence, we continue to support its safe use.”
Zuckerman added that part of the problem lies in the heavy influence that industry has on members of Congress and the FDA. “Whenever the FDA does something to improve patient safeguards, Members of Congress get lobbied by the industry involved and some of those Members pressure [the] FDA to back off,” she wrote in an e-mail. “This has happened for years but the last few years have been even worse than usual.”
At Mother Jones, Tom Philpott points out that the heavily monied interests behind BPA are none other than the chemical giants Dow and Bayer who produce the bulk of BPA. Frederick S. vom Saal, curators’ professor at the University of Missouri-Columbia and BPA researcher told me that BPA represents a $10 billion a year industry. It’s important to note that the recent FDA ban comes at the behest of the American Chemistry Council, an industry trade group that denies any negative health effects from BPA. Why would they have done this? “[The American Chemistry Council’s] petition to the FDA puts it plainly: ‘All Major Product Manufacturers Have Abandoned the Use of Polycarbonate’ (BPA). In other words: Go ahead and ban it—it’s already been phased out and a ban gives the appearance of strict oversight,” Philpott writes.
By creating the ban, the FDA at least acknowledges that babies and children should lessen their exposure to BPA. But what about the rest of the population? “BPA remains in millions of food and beverage containers that affect the BPA levels of pregnant women, children of all ages, and all adults,” Zuckerman wrote to me in an e-mail. “The impact on the developing fetus and young children, and on breast cancer patients undergoing chemotherapy, are of particular concern to our Center. One study indicates that BPA may interfere with the effectiveness of chemo for breast cancer patients.”
The FDA should concede that if BPA is a risk for babies and children, it is most likely a risk to all of us. And what about the various substitutes that will be used for BPA and the numerous other toxins lurking in the plastics and other containers that package our foods and drinks? “FDA’s decision is a step in the right direction, but it is a baby step,” Zuckerman said. “They have done the minimum.” Blumberg added that the answers to all of these questions are complex. “We do not know nearly as much as we need to know,” he said. “I think that it is prudent to reduce our consumption of packaged foods of all sorts for a variety of reasons, including reducing exposure to contaminants from the containers.”
Photo: Baby with bottle, by Shutterstock
“By creating the ban, the FDA at least acknowledges that babies and children should lessen their exposure to BPA. ”
Unfortunately, this is simply not true. They withdrew approval at the request of the American Chemistry Council, which represents the manufacturers of BPA. The federal register says:
 would they do this? To STOP the FDA from acknowledging any harm from BPA.:
.”
We are all being conned by the American Chemistry Council here. Manufacturers had already abandoned BPA in bottles and sippy cups; now they have Federal protection against imports and defend their position in epoxies by delaying the science.