Estate Planning for Equine Owners
>>IMAGE ‘Somebody exclusion amounts are gradually increasing from $2 million in 2007 to $3.5 million in 2009. In 2010 there is no estate tax, and in 2011 the applicable exclusion amount remains uncertain. Estates that exceed the exclusion amount may be subject to federal tax ranging from 36%-55% (1). This can leave a large hole in what remains of the estate for heirs. You may be thinking, “My estate couldn’t possibly be over the exclusion amount, $2 million is a lot of money so I shouldn’t worry about estate tax." Remember the uncertainty surrounding the exclusion amount in 2011, the lower that amount remains, the more revenue the government gains in taxes. If the amount settles back to a $1 million exclusion,.
Probate issues
The ultimate goal of estate planning is to efficiently transfer assets and property from one generation to another. There are a few different ways this can be accomplished: 1) by passing through the probate process, 2) by right of a contract with named beneficiaries, or 3) by rights of survivorship whereby when one owner dies, everything transfers automatically to the other owner.
The probate process is one of the most important concepts to understand in estate planning. When an individual dies and leaves a will, his or her estate goes through probate, by which a state court supervises, administers and distributes the property. The probate estate includes all of the property that is in your name at the time of your death. Providing that there is no successful challenge in probate proceedings, the court will allow a final distribution of your estate after all debts and taxes are satisfied.
In the alternative, property owned by right of contract and by right of survivorship will pass outside the probate process. These assets avoid the delay and public record of the judicial system. Some examples of non-probate property includes: 1) property held in a trust where the property passes to others on death according to the terms of the document, 2) property owned in joint tenancy at death which passes to the surviving joint tenant automatically on death, 3) life insurance on your life that names a beneficiary other than your estate, and 4) qualified plans, such as 401(k)s and IRAs that name a beneficiary other than your estate.
Revocable living trusts
One of the more popular probate-avoiding estate planning tools is the revocable living trust. A revocable living trust creates a legal entity that owns your assets. You can dictate the provisions of the trust document which will control the disposition of the assets inside the trust during your disability or your death. For example, if you have certain wishes for a pet or a horse you can outline them within these trust provisions. The person who must follow the directions outlined in the trust is the trustee, they hold fiduciary duty. Typically, the initial trustee of a revocable living trust is you. Upon your death or disability, a successor trustee, whom you named in the trust document, takes over to distribute your property according to your wishes.
Equine assets in the estate
Please remember that anyone with assets, family, children or horses should evaluate an estate plan. If you have children, a will is necessary to ensure that if you die, you (and not a judge) have chosen a guardian for them. For those of us with horses, remember that with proper care and a little luck, horses can live for 25 to 30 years, sometimes even outliving their owners. When that happens, the surviving horses become tangible personal property in the estates of their deceased owners. Though subject to laws prohibiting cruelty to animals, the law treats surviving horses and other companion animals just like any other assets in the estate. Unless specific instructions are provided in an estate plan, the executor or administrator of the estate has the discretion to keep the equine asset in the estate, sell it at auction or by private treaty or otherwise humanely dispose of it, such as by euthanasia.
Pet trusts
Another trust which is becoming increasingly popular with pet owners is a pet trust. Several states, including Oregon, permit legally enforceable pet trusts so that individuals can transfer funds to an enforceable trust to provide for the care of their pet. In a pet trust, you name a trustee who will carry out your wishes for the animal, and provide detailed instructions for the distribution of trust funds for the animal’s care. In addition, you name a caretaker who will care for the pet if you cannot do so. The document should include the identity of the pet, the amount of compensation for the pet’s caretaker, and should specify additional details and instructions about the care of the animal, its habits and needs, end-of-life decisions, and other guidelines and instructions that would be important to the care and support of your companion animals.
Estate planning for pets and other companion animals like horses is a new niche, so you will want to seek out an attorney who is well-versed in this area of the law. When establishing any trust, however, you will need to hire an attorney to draft the trust, preferably a lawyer with experience in estate planning. Eden Rose Brown, an estate planning attorney out of Salem, OR has drafted many pet trusts over the years and has found that, “We’ve had a number of clients who feel that sometimes their pets are more important than their children.” She emphasizes that in the right situation, a pet trust is a responsible, loving thing to do for your pets and is an important part of a comprehensive estate plan.
It is important to understand that a trust is just an empty bucket until the appropriate assets are re-titled into the name of the trust. As we discussed above, the way the asset is titled dictates whether the asset will avoid probate. Many times clients spend a great deal of money to have an attorney draft a trust in order to avoid probate but never change the ownership of their assets. The consequences of this inaction may force some of these “unfunded” assets to go through probate. Therefore, it is very important that if you do set up a trust, be sure to use an attorney who knows how to assist you in the proper transfer of your assets into the name of the trust.
Estate planning is important
Though proper estate planning can sometimes be a complex process, having the right professional team can lift much of that burden. And while getting started can be daunting, remember the values that guide you and your family, and let those guide the process. Taking the time to think about these issues will preserve your life’s work for your family, your horses and your community.!
Published: May 13, 2010; Updated:
1) *This information is a general discussion of the relevant tax laws. It is not intended for, nor can it be used by any taxpayer for the purpose of avoiding federal tax penalties. This information is provided to support the promotion or marketing of ideas that may benefit the taxpayer. Taxpayers should seek the advice of their own tax and legal advisors regarding any tax and legal issues applicable to their specific circumstances.