Years ago, there was a popular TV game show called \u201cTruth or Consequences.\u201d It required contestants to correctly answer questions or otherwise face a consequence \u2014 usually, a silly stunt, though sometimes producers surprised viewers with a tearful personal reunion like a soldier\u2019s return home. Bob Barker, one of the show\u2019s hosts, had a memorable sign-off: \u201cHoping all your consequences are happy ones.\u201d Given how much we doubt the presentation of \u201ctruth\u201d in our current era, Barker\u2019s sign-off got me thinking. For one thing, is truth still important to us, or is it a relic of the past? And for another, what are the consequences of our skepticism about what is told to us as \u201ctrue?\u201d \u201cHappy\u201d doesn\u2019t seem to follow. We have many data points to suggest we don\u2019t trust what we see or hear. As relates to government, a 2020 Pew study reports that across party lines, only 20% of U.S. adults trust their elected officials. Hence the joke, \u201cHow do you know if a politician is lying?\u201d Answer: \u201cHis lips are moving.\u201d And it\u2019s not just in politics that we\u2019ve become disbelievers. We used to trust our scientists. After all, science is steeped in research and facts. Today? Not so much. Again, Pew reports that in February 2020, only 51% of respondents hold a \u201cfair amount\u201d of confidence in scientists. COVID-19 has likely further eroded that percentage. So, by and large, we don\u2019t trust the government and are cautious regarding scientists. How does social media fare? An MIT study reviewed 126,000 stories spread on Twitter, where the study\u2019s reviewers characterized the stories as true or false based on six independent fact-checking organizations. What did the study\u2019s co-author, Sinan Aral find? \u201cFalsehoods travel farther, faster, deeper, and more broadly than the truth, in all categories of information, and in many cases by an order of magnitude.\u201d This probably helps to explain why only 35% of all adults trust the political news they get on social media (Pew, 2019). This sounds like another variation of the stale joke about how the politician. How do we know if social media is lying? It\u2019s sharing a story. It\u2019s one thing to feel a diminished sense of truth in the people and news sources around us. It\u2019s another to consider how lying has impacted our own personal behavior. Here\u2019s a seemingly innocuous example. How often do you use \u201cgotta go\u201d when trying to get off the phone when you actually don\u2019t \u201cgotta go?\u201d Usually, the sayer follows with a fake line, like \u201cGotta walk my dog.\u201d I will fess up to using this myself. Sometimes our lying has a humane aspect to it \u2014 what we often call a \u201cwhite lie.\u201d Maybe you\u2019ve engaged with someone who has particularly struggled during COVID-19, and you say something like, \u201cYou look like you are holding up well,\u201d when clearly they\u2019re not. I\u2019ve committed this one, too. The alternative of saying nothing and letting the silence hang or saying something truthful like, \u201cMany people are choosing to go gray\u201d does not seem any better. There are, of course, the lies we tell that have no possible social redemption. Constructing a false online dating profile with a PhotoShopped picture is an example. I am told some people even misrepresent their marital status. There is the deceptive practice of \u201castroturfing,\u201d where we cook up positive reviews of a product in large amounts to facilitate adoption, such as the case of fake book reviews. All this lying \u2014 in so many forms and degrees \u2014 might make us feel like the ancient Greek philosopher Diogenes who is said to have lit a lamp in broad daylight as he went about looking for \u201ca single honest man.\u201d Where will we find our single honest man? And what are the consequences are of living in a culture where being duped is assumed. Gone are the days where we did business on a handshake or said, \u201cI give you my word,\u201d and it was sufficient. The consequences of lying are steep and may go as deep as a loss of self-esteem, disillusionment in our future, and more fragile relationships. Perhaps Mark Twain\u2019s lighter but ever so true words can guide us, \u201cIf you tell the truth, you don\u2019t have to remember anything.\u201d Jill Ebstein is the editor of the \u201cAt My Pace\u201d series of books and the founder of Sized Right Marketing, a Newton, Massachusetts, consulting firm. She wrote this for InsideSources.com.