Marketing Communications Specialist at ERP Maestro.
7 Insights on the State of Cybersecurity
As we close out 2018, it’s a good time to take stock of the state of cybersecurity. It’s been yet another difficult year. High-profile breaches and cyberattacks continued to dominate the headlines, and while cybersecurity is getting more attention in organizations, it appears for all of the time and money spent, security incidents only continue to plague organizations. A cyberattack is no longer a matter of if it will happen, but when it will happen. Organizations must prepare themselves for a cybersecurity incident through education, prevention strategies, crisis plans and tools that can help keep a company secure.
Below are seven eye-opening facts about cybersecurity in our current environment that every company should know.
Cybercrime is costing us millions
Spending on cybercrime increases annually, and as a result the associated costs for a cybersecurity strategy continue to climb each year. Organizations spent nearly 23 percent more on cybersecurity in 2017 than 2016 — on average about $11.7 million, according to figures from Accenture. Their figures also find the average cost of a malware attack on a company is $2.4 million.
Breach costs are also rising
The annual 2018 Cost of a Data Breach Study from IBM Security and Ponemon Institute finds the global average cost of a data breach is $3.86 million, up 6.4 percent from 2017. Each lost or stolen record costs a company $148 per record.
Breaches are also getting larger and more serious annually. In early December we learned about the whopping 500 million customers potentially impacted by the breach suffered by hotel giant Marriott. Some of the compromised data on guests includes names, phone numbers, email addresses, passport numbers and dates of birth. Credit card numbers and expiration dates on some also may have been exposed.
When it comes to the cost of breaches by nation, the US tops the list with a $7.91 million average cost for a breach, with Canada and Germany right behind the US. Moreover, this trend shows no signs of slowing down.
Most losses suffered in a cyberattack are never recovered
According to a recent article in PC World, 68 percent of funds lost as a result of a cyberattack were declared unrecoverable. The article goes on to note the average time to detect a malicious or criminal attack was 170 days – nearly six months!
This brings us back to the Marriott breach. Officials with Marriott said they had been warned by a security alert in September about an attempt to access the Starwood Hotels reservation database in the US. They took action and investigated – and found out a criminal had had unauthorized access to the Starwood database for four years – since 2014! Four years is plenty of time to do maximum damage and steal countless amounts of sensitive information.
Insider threats can cost millions
Insider breaches are among the most expensive and toughest to detect. According to Ponemon Institute, the average cost of insider threats to a business is more than $8 million, and 59 percent of employees steal proprietary corporate data when they quit or are fired.
According to the 2018 IBM X-Force Threat Intelligence Index, two-thirds of total data records compromised last year were the result of inadvertent insiders. Insider threats are the cause of 75 percent of security breach incidents by some accounts. Recent research from Forrester reveals more than half of global network security decision makers whose firms had suffered a data breach in the past 12 months had experienced at least one insider incident.
Human error is responsible for many incidents
While many security incidents are malicious, there are also a large percentage due simply to human error and employee negligence.
Prior to Marriott, last year’s massive, headline-making breach was suffered by Equifax, which exposed the records of nearly 146 million Americans and was reported to be the result of one employee’s error. How? According to Congressional testimony given by former Equifax CEO Richard F. Smith, an “individual” in Equifax’s technology department neglected to heed security warnings and did not ensure the implementation of software fixes that would have prevented the breach.
A report from Experian titled Managing Insider Risk Through Training and Culture Report found 66 percent of the data protection and privacy training professionals surveyed considered employees the “weakest link” when it came to cyber security.
Proper Segregation of Duties (SoD) can reduce internal fraud and mistakes
Many businesses are overlooking Segregation of Duties (SoD) as part of their security strategy. SoD is one of the most obvious controls to minimize insider threats. According to Gartner’s 2017 Market Guide, effective segregation of duties controls can reduce the risk of internal fraud by up to 60 percent, and some of the largest corporate fraud cases in history have been the result a lack of SoD controls.
A talent shortage is only going to make things harder
The skills gap and talent shortage in the security industry is well documented. An estimated 3.5 million cybersecurity positions will be unfilled by 2021, according to a 2017 report from Cybersecurity Ventures.
In what many are calling an “industry crisis,” hiring managers are desperately looking for security talent and need to get creative. In the meantime, criminals are getting more sophisticated and keeping them at bay is only going to get more difficult as the talent shortage stresses security departments. In the absence of skilled people to fill jobs, organizations will increasingly look to automation and tools to supplement their security strategy.
Final facts
These statistics are sobering, so is the rise of concern around the globe that has brought about legislation to place more of the onus on senior managers and executives for security breaches, fraud and mishaps. The UK’s Senior Managers and Certification Regime (SMCR) puts more personal liability for governance, risk and compliance on the shoulders of key senior employees. If you want to learn more about this, we’ve written about it here: “Will Emerging Legislation on Internal Controls Make You Personally Liable?”
Variations of the same law are cropping up elsewhere in countries such as Australia and Singapore. And after the Equifax and Marriott incidents, government officials in the US have pressed for new legislation that would levy civil penalties for private sector violations.
Will putting more executive skin in the game help businesses to take cybersecurity more seriously? That remains to be seen, but what is starkly evident is the need to keep cybersecurity at the forefront of corporate priorities.