I first encountered the idea of frame of reference while an undergrad studying Physics. To the man walking down the aisle of the airplane, he’s walking a few miles per hour. From the frame of reference of someone on the ground, he’s walking several hundred miles per hour. Frame of reference refers to the myriad ways we can see the same activity. In Hatha Yoga, there are relatively few positions, though each position may relate to gravity in many different ways. Sometimes the best way to learn a given posture is to study that form in a different context.
When I first began my studies of Yoga, I was taught to lift the chest and pull the shoulders back when standing in Mountain Pose. In observing the epidemic of poor posture, this was a logical instruction. What was interesting to note, however, was how rarely this instruction led to any degree of comfort in the body. Yes, it momentarily corrected poor posture, though the benefits were often short-lived and the practitioner usually looked ill-at-ease. In many ways, the poor posture seemed more authentic, as there was less of a contrived quality.
Virtually all of us have caught sight of our reflection in a mirror or window and were shocked to see how pitched forward our head and shoulders were. Our motivation to correct this imbalanced state is well-founded, though changing the frame of reference usually yields the best results. I’ve found learning how to stand best happens on the floor. As a result, I’ve come to teach Prone Mountain far more often than I teach Mountain Pose (Tadasana).
Prone Mountain begins, as the name implies, on the belly. Start with your hands flat on the floor with your wrists beside the lower ribs. Many people find their head falling into the floor, while their chest is off the floor – this is the head-forward posture revealing itself. To build better posture, bring your chest as close as possible to the floor (flesh of the chest firm against the floor) while simultaneously lifting your nose and chin slightly off the floor. To fully realize the benefits for the spine, extend out through the crown of the head, while at the same time, stretching back through the outstretched toes. By practicing Prone Mountain in this way, you gently remind the body of its optimal spinal alignment, while building the core postural strength to help maintain good posture.
The next step is to find ease and comfort in the shoulders. The shoulders mirror the state of the lungs. If the shoulders are rounded forward, the lungs are often too cool. If the shoulders are pulled back too much, the lungs are often overheated. One is not preferable to the other – they’re both imbalances. As with most natural systems, there is a middle way that best serves the system. Prone Mountain pose helps us find the middle way of optimal health.
Return to Prone Mountain and find the optimal spinal alignment we explored earlier, and bring your attention to the shoulders. Very often at the very mention of shoulders, people reflexively pull them back to the spine. Yes, the chest is more open, but at what cost to the back lungs? Remember: the torso is three-dimensional. Opening the chest by compressing the back is a zero net gain. The optimal posture opens both front lungs and back lungs at the same time.
To do this, simply think of broadening across the place where the arm inserts into the shoulder socket. (It can be useful to have someone press on the posterior deltoid to provide feedback.) You know you’re on the right track when both upper back and chest feel broad and spacious, and you can feel the rhythmic movement of breathing in both your front and back. Don’t worry about keeping the elbows drawn in tight to your torso – in the big picture, it’s not the most important element.
When you practice Prone Mountain, the first step is to find the optimal spinal alignment. Once you’ve found this optimal alignment and created extension in the spine, find the optimal shoulder alignment such that both front and back lungs are involved with the breathing. Let this feeling seep into your body-mind for one-five minutes. You’ll likely feel the benefits of Prone Mountain once you come up on your feet into Tadasana. Your body will remember optimal alignment once it’s had the taste.
This is the first installment of Prone Mountain and Optimal Posture. Next time we’ll cover the relationship of the spine to the fore/aft body, and how the Spine Bag helps resolve long-standing postural imbalances. In the process, we’ll also expand on the frame-of-reference imagery.
Until then, Happy Holidays from all of us at Alignment Yoga!
~ Scott
4 comments:
Great entry Scott. Just this morning I sent an email to a friend in NYC detailing prone mountain...guess I should have checked the blog first! I will pass this along.
Scott, the instruction here is amazing, but I am wondering if you would include a few pictures to help us beginners visualize what you are speaking of?
It can be hard to visualize all this without images, can't it? I'll be filming a video blog entry later this month that corresponds to this essay - it'll provide step-by-step instructions. Thanks for reading!
Who knows where to download XRumer 5.0 Palladium?
Help, please. All recommend this program to effectively advertise on the Internet, this is the best program!