VIA is a central tenet of the program.
Our participants come to the program with a wide range of disabilities including physical and intellectual disabilities, learning disabilities, mental health and addictions. We work with each person as an individual to help them recognize showcase and enact their unique strengths and create hope, optimism and flourishing in the world of work.
Somewhere along the way, we realized that we are pioneers in working with such a wide cross section of people with disabilities and intersectionality gathered together in one room. We are truly a village – participants, educators, classroom assistants, social work practicum students, coaches, employment specialists all supported by an amazing agency and their program team. We pay special attention to training and orienting this village to the culture and context of the program and toward social action and supports in the broader context. We’ve learned a lot from our experience and most of all from our greatest teachers, our participants.
We’d like to share some of what we’ve learned:
- We’ve learned that in order to help participants connect their VIA Strengths to the world of work, we need to help them recognize and learn to tell stories about how they have used their strengths: in previous job experiences; in volunteer work; in school; with friends and family and in the community.
- We have created unique exercises that help integrate VIA Strengths into every aspect of our work:
- Spotting strengths through peak experience story telling
- Re-imagining past difficult situations using strengths to create new possibilities for future outcomes
- Celebrating a “character strength of the day” by brainstorming about the meaning of that strength and what behaviours might look like at work
- Weaving strengths into “STAR” Stories to prepare for behavioural interviews
- Creating a “Work-life Portfolio” as a reflective learning tool
- Implementing a follow up journal for use after the classroom portion of the program is complete to help participants spot their use of VIA strengths outside the classroom, to consider overuse and underuse and to reflect on ways to combine signature strengths to boost lesser strengths
- Some participants complete the survey in 15 minutes while others need support for about an hour, all depending on the nature of the person’s ability. We are considering using the VIA Survey supplemental guide to assist people with different disabilities to complete the VIA Survey in a validated way (the free PDF can be found here). The good news is that either way, it can be done with minimal intervention and maximum joy! Perhaps these are the participants that revel in learning their unique strengths profile the most!
- On the last day of a recent program, we asked participants to “Pay it Forward”, to let future participants know what they had gained through learning about their VIA Strengths. Here are some wise words they shared:
- “I have learned to have clear conversations around who I am, and what my strengths and weaknesses are.”
- “Knowing my strengths allows me to put them forward in a timely and beneficial manner to [a] potential employer. They empower me.”
My consulting firm PersonaGrata Consulting was commissioned to develop the program and to provide Learning and Coaching Practice Leadership. One of the reasons the social service agency, Brands for Canada selected us, was that VIA Strengths is at the centrepiece of the work we do, whether it is program development, education or coaching. Together, we have a created a unique collaborative alliance. Adler Professional Coach Training enables us to recruit professionally trained coaches to work with our participants individually. DIG Insights is our professional, credentialed evaluator, so that we can validate the efficacy of our program and ensure long-term program funding.
We are grateful for the guidance of The VIA Institute on Character for their encouragement in joining together Positive Psychology practitioners from around the world to share research and resources on strengths work for people with disabilities. We are also grateful to Darren Coppin of Esher House UK for his wisdom and his research on positive psychology interventions for people who are long term unemployed.
We hope that future developments for the program will include a program for training employers in hiring and helping people with disabilities flourish in the workplace; expanding the scope and reach for our Coaching for Social Purpose Coach training model and overall expanding our geographic reach.
There is a real human and social cost of unemployment for people with disabilities. Together, PersonaGrata Consulting, Brands for Canada, Adler Professional Coach Training and Dig Insights have created a unique collaborative partnership to supercharge employment outcomes for people with disabilities.
By: Deborah Miller, ACC, CCDP, MEd (2019)
A positive educator, coach and consultant, Deborah Miller is Managing Director for PersonaGrata Consulting. Deborah is deeply invested in bringing together the essential elements for marginalized clients to create a productive and meaningful life in the world of work.
Deborah is currently completing a Masters Degree in Adult Education with a focus on the power of transformative education. Her credentials include Associate Certified Coach (ACC) and Certified Career Development Practitioner (CCDP). Deborah is a member of the Canadian and International Positive Psychology Associations, the International Coach Federation and the Career Development Practitioners Certification Board of Ontario.
Filed Under: Latest From the Blog, VIA Strengths at Work, VIA Strengths general, VIA Strengths Tips
Tags: character strengths, disabilities, strengths and disabilities, VIA strengths