I wager that an informal poll of IT admins across all disciplines would show that most do not bother with SNMP (Simple Network Management Protocol), and those who use SNMP do so in conjunction with basic read-only monitoring frameworks. I'd also wager that of those using SNMP, most are using SNMPv1 and have never looked into why they would want SNMPv3. This is largely because SNMP is archaic and should be put out to pasture.
I don't think any one really likes using SNMP, especially those who have to wade through vendor MIBs looking for a way to poll hardware or software for some piece of data. The fact that every vendor still supports SNMPv1, and many still use a default read-only SNMP community of "public," enabled by default, shows how apathetic we are regarding SNMP as a whole.
[ Also on InfoWorld: SDN 101: Software-defined networking in 10 easy steps | Get expert networking how-to advice from InfoWorld's Networking Deep Dive PDF special report. ]
I say this as someone who has written lots of code that directly interfaces with and manipulates hardware and software through SNMP calls. I have written plug-ins for Cacti and Nagios that use SNMP extensively to glean data out of everything from storage arrays to managed rack PDUs. I used SNMP calls in a custom Web app that finds the switch and switch port that the requesting system is connected to and allows the user to change the VLAN assignment for that port. (This turned out to be a very handy app, especially when turning up new office space with hundreds of users.)
I know SNMP very well, and I think it's long past time that we move toward a saner and more useful solution to solve the problems SNMP was developed to address. That said, I'm not sure I see anything really promising in that arena.
Tools like NetConf (Network Configuration Protocol) and YANG exist as alternatives to SNMP, but they're relatively new and so far largely ignored. NetConf, an XML-based network management protocol first developed in 2006, allows for content, operations, and RPC data to be sent and received from compatible software via BEEP, SSL, SSH, and console connections. As an example, you could construct an XML request for a router to return its current running configuration, which would be delivered via XML, or you could issue commands to the device via other XML-based communication. YANG is a language designed to model the data for NetConf and provide for a more human-readable interface. Between the two, we see a new method for controlling networked devices that is an improvement to managing those devices via SNMP.
The problem is that NetConf was never intended to be a replacement for SNMP; members of the IETF NetConf working group stated exactly that. The fact that it can perform most or all of the same tasks as SNMP is largely immaterial if it's not geared toward eventually supplanting SNMP itself. If anything, NetConf is aiming more toward replacing the command-line interface than anything else. Even in that regard, it's not widely used or supported. Only a handful of vendors provide NetConf support, and even though that includes Cisco, the support is generally subpar, most likely due to lack of interest.
We're left with SNMP for who knows how long. Very few protocols and technologies maintain a majority deployment at their initial revision, but SNMP is an example of exactly that. Though SNMPv3 has been the current standard version for almost 10 years old, 25-year-old SNMPv1 enjoys a much greater footprint. Compare that to other protocols that have moved quickly away from their initial release, such as NFS, which has standardized on version 3. You'd be hard-pressed to find support for elderly versions of many communication protocols in modern hardware and software, but in most cases you'll find that not only is SNMPv1 supported, it's preferred over v2 and v3 by default.
I suppose not enough people care enough about SNMP to bother pushing for a replacement. Many vendors are using their own APIs to control their own hardware through their own software interfaces, and offering SNMP support as a generic and largely unused service. Thus proprietary interfaces make an end-run around the concept of a standardized management protocol.
In truth, the only way SNMP becomes a relic of the past may be through the wholesale reengineering of networking and networked devices via SDN (software-defined networking). Separating the data and control plane as SDN does changes the entire model of metric collection and hardware and software configuration. It essentially makes SNMP irrelevant. In fact, SDN will make a lot of things irrelevant, as we'll see in the not-so-distant future.
Perhaps the best idea is not to reinvent SNMP, but to recognize it as a facet of an era that will soon be over. We'll reinvent everything else instead.
This story, "SNMP: No one likes it, yet no one cares to replace it," was originally published at InfoWorld.com. Read more of Paul Venezia's The Deep End blog at InfoWorld.com. For the latest business technology news, follow InfoWorld.com on Twitter.