'Listen to This': When Ross Looks Into the Future of Music, He's Insightful and Engaging
This collection contains moments of brilliance and flashes of frustration, disappointing only compared to the author's previous, masterful full-length book.
Since 1996, Alex Ross has been fighting the good fight for classical music in the pages of The New Yorker, trying to dispel the notion that his preferred genre is old fashioned, outmoded, and stuffy. He's done an admirable job. Never elitist or dismissive, Ross feels that classical music can be enjoyed alongside popular music and that any notion that there must be conflict between the two sides is overblown.
His 2007 book The Rest is Noise, which gave some much deserved attention to 20th century classical music, was a massive success and achieved its goal in reaching beyond classical music's typical audience. His new book, Listen to This, collects what Ross feels are his best articles from his years writing in The New Yorker, with one brand-new piece for good measure.
The strongest essays in Listen to This are those that provide a window into the methods and motivations of artists who have committed themselves to living on the frontiers of music. In "Song of the Earth", Ross profiles John Luther Adams, a modern composer for whom the Alaskan wilderness is more than just inspiration, it's an instrument itself. His work, The Place Where You Go to Listen feeds real-time measurements of local seismographic, meteorological, and geomagnetic information into a computer, which translates it into audible, electronic music. This examination of Adams' progressive work and colorful life offers Ross an opportunity to provide a capsule summary of modern composition's influences and evolution, intertwined with a lovely journey through the composer's natural environment.
Ross goes out of his way to explain that, while classical music is his passion, he also has an affinity for rock and popular music. It's no surprise, however, that his favorites tend to be those artists who draw from the classical and experimental. "Emotional Landscapes" is a winning and revealing account of the recording of Björk's 2004 album Medulla, a beautifully daring album constructed almost entirely out of a capella human vocals. It's a welcome insight into the demeanor and creative process of an artist often unfairly caricatured as peculiar or eccentric. Ross shows Björk to be a thoughtful, hard-working musician, one whose experimental tendencies are motivated by a sincere interest in new and exciting means of expression.
In his preface, Ross points out that music criticism can often be overly technical ("Beethoven's Fifth begins with three Gs and an E-flat") or grossly purple ("Beethoven's Fifth begins with fate knocking at the door."). Despite his awareness of such traps, Ross often falls into them, sometimes enthusiastically. His new piece, "Chacona, Lamento, Walking Blues" suffers greatly from the former, hinging as it does on the subtle, nuanced evolution of a series of simple bass lines over the course of 400 years. What he describes as a "whirlwind history" is dizzying and disorienting; it's obvious that Ross feels this story is significant, but he gets so wrapped up in the compositional details, it's never entirely clear why.
Writers are most susceptible to purple prose at the beginning and end of pieces, and Ross is no exception. He opens his meditation on Bob Dylan with a woefully dissonant attempt to grab the reader: "America is no country for old men. Pop culture is a pedophile's delight." His short take on Sonic Youth's A Thousand Leaves and Anagrama closes with the entirely unsupported and perplexing declaration that "Sonic Youth are now writing, in the best sense, classical music."
When Ross looks into the future of music, as he does in the chapter detailing the rise of interest in Western classical music in contemporary China, he's insightful and engaging. When he looks into the past, as in "Verdi's Grip" or the Brahms-focused "Blessed are the Sad", his writing can become a little stilted, lost in a lexicon in which he feels comfortable but that his readers may find tedious. Listen to This contains moments of brilliance and flashes of frustration, and is disappointing only compared to the author's previous, masterful full-length book.