Joy, grief, anger, jealousy, love… Scientists increasingly believe that animals feel emotions just like humans do, and these emotions play a critical role in their lives.
Emotions can be defined as a conscious mental reaction subjectively experienced as a strong feeling usually directed toward a specific object and typically accompanied by physiological and behavioral changes in the body. Scientists try to study emotions by splitting them into three components: physiological (how the body responds), behavioural (what one shows to others) and psychological (what one feels) responses.
Emotions differ from sensations, which are only physical consequences (eg heat), and from feelings, which refer to only internal states with no reference to external reactions.
Emotions in animals were first described by Charles Darwin in 1872, where he described emotions as stereotyped facial expressions and bodily postures in specific contexts. Darwin explored the expression of emotions not only by humans but also by cats, dogs, horses and many other animals. Darwin observed similarities between human and non-human animal expressions, in line with his theory of continuity between species.
Darwin’s work on animal emotions was criticised for approximately 100 years and until relatively recently, many scientists thought it was impossible to scientifically study animal emotion, and anyone who did so was thought to be wrongly attributing human thoughts and feelings to animals (anthropomorphism).
Today it is acknowledged that the latest scientific findings indicate that emotions play an essential role in rational decision-making, perception, learning and a variety of other cognitive emotions . If this is the case for humans, then, many argue, why not also for other animals.
A review of animal emotion by scientists at Bristol University suggested that, as in humans, emotions may tell animals about how dangerous or opportunity-laden their world is, and guide the choices that they make.
It is generally agreed by scientists that animals have emotional responses, such as increased heart rate or release of hormones in the blood (physiological) and responses such as attempts to escape a situation (behavioural). However, the issue of whether animals actually feel emotions (the psychological component) remains controversial. This is largely due to the fact that it is impossible to actually get inside another animal’s mind (as it is to get inside another person’s head).
However, based on physiology, it’s reasonable to assume most animals feel emotions. Other mammals for example have brain structures similar to humans, and the way their brain works is similar to the way the human brain works.
We may be quicker to appreciate the intelligence and sentience of animals such as primates as they are so much more similar to us in their gestures and experiences, and therefore easier for us to read. We may have been slower to understand the complexity and richness of other creatures such as fish and whales simply because they appear to be so very different to us.
Scientist and author Marc Bekoff believes that it is obvious that animals feel emotions: “Are we really the only animals who experience a wide variety of feelings? In my view the real question is why emotions have evolved not if they have evolved in some animals. So, for example, it’s a waste of time to ask if dogs or chimpanzees experience emotions such as joy, grief, anger and jealousy. Animals’ emotions function as a ‘social glue’ and as ‘social catalysts’. Their emotions and mood swings grab us. It is highly likely that many animals exclaim ‘Wow!’ or ‘My goodness, what is happening?” as they go through their days, enjoying some activities and also experiencing enduring pain and suffering at the hands of humans. What animals feel is more important than what they know when we consider what sorts of treatment are permissible. When in doubt, err on the side of the animals.”
Modern animal welfare concerns stem from the recognition that animals are sentient beings able to experience emotions such as fear, pain, joy and contentment. Animal emotions thus form the core of many scientific definitions of animal welfare. However, there has previously been a lack of scientific research in this area.
Leading animal welfare scientist Marian Stamp Dawkins from Oxford University points out that the possibility of conscious experiences of emotions in non-human animals has been much less explored than that of conscious experiences associated with carrying out complex cognitive tasks . She says: “However, no great cognitive powers are needed to feel hunger or pain and it may be that the capacity to feel emotions is widespread in the animal kingdom.”
In recent years there has been a surge in interest in studying emotions in other animals and our knowledge is growing all the time. Every day scientists across the world are producing increasing evidence that, like humans, other animals feel emotions.
A range of emotions have been investigated in a number of animals including dogs, sheep, cows and whales.
Clich here to watch some informative and inspiring films about animal emotions.
References
- Darwin C 1872 The Expression of Emotions in Man and Animals
- Picard, R.W 1997 Affective computing. Cambridge, UK: MIT Press.
- Mendl M, Burman O. H. P and Paul E. S 2010 An integrative and functional framework for the study of animal emotion and mood. Proceedings of the Royal Society B, vol. 277, no. 1696, 2895-2904
- Bekoff M 2006 Animal Emotions and Animal Sentience and Why They Matter: Blending ‘Science Sense’ with Common Sense, Compassion and Heart. Animals, Ethics and Trade. London: Earthscan
- Dawkins M. S 2006 Quality of life, good welfare and the animal’s point of view. Proceedings of the Quality of Life: the Heart of the Matter. UFAW: Wheathampstead, Herts, UK.
- Duncan I. J. H 1993 Welfare is to do with what animals feel. Journal of Agricultural and Environmental Ethics 6:8-14
- Veisser I and Boissy A 2007 Stress and welfare: two complimentary concepts that are intrinsically related to the animal’s point of view. Psychology & Behaviour 92:429-433
- Dawkins M.S 2000 Animal Minds and Animal Emotions. Integrative and Comparative Biology, Volume 40, Issue 6, 883-888.