Retirement should, ideally, be a period of enjoyment, but it takes money to make that happen. As we head into 2018, here are a few things you can do to increase your wealth.
1. Be smart about taxes
The less money you lose to taxes, the more you'll have available to use in the coming year. The first tax move you might consider is one that has an end-of-year deadline: Sell underperforming investments at a loss. The reason? You can use losses to offset capital gains, so if you're holding an investment that's taken a tumble and you don't expect it to recover, cashing it out this year could offset earnings on gains, thus lowering your tax bill. (Of course, you can also do the same in the following year, but if you move quickly, you'll shave money off your upcoming return.)
IMAGE SOURCE: GETTY IMAGES.
Furthermore, once the new year kicks off, there are several moves you can make to keep your taxes to a minimum. For one thing, if you happen to be downsizing, donate the household items you're not planning to move rather than throw them away. If you give them to a registered charity, you can deduct their fair market value on your return.
Additionally, if you're investing a bunch of your savings in bonds, which is something retirees tend to do, consider focusing on municipal bonds over corporate ones. The interest income you collect from municipal bonds is guaranteed to be tax-exempt at the federal level. And if you buy bonds issued by your home state, you'll avoid state and local taxes to boot.
These are only some of the tax moves that might save you big bucks next year, so it pays to read up on different strategies and deductions you might be eligible for. Or, talk to a tax professional who can help guide you through the process.
2. Pay attention to required minimum distributions
As the current year rapidly comes to a close, be sure to stay on top of whatever required minimum distribution (RMD) you're required to take from your retirement savings. RMDs kick in once you turn 70 1/2 if you have a traditional 401(k) or IRA. (Roth accounts don't impose RMDs.) Once you calculate the amount you're required to withdraw, make a point of collecting that money before the deadline. Otherwise, you'll be hit with a 50% tax penalty on whatever funds you fail to remove.
Now if you just turned 70 1/2 this year, you get until April 1 to collect your first RMD. But if this isn't the first year you're on the hook for RMDs, then you'll need to withdraw your money by Dec. 31 to avoid penalties. And while you may not want to take that distribution, it's better to enter the new year with extra cash than to give up a chunk of your savings.
3. Keep investing money you're not using
If you have a bunch of money sitting in your IRA, 401(k), or traditional brokerage account, and you don't expect to need all of it within the next five to seven years, then it pays to invest what you aren't going to use. Contrary to what you may have been told, there's no reason to avoid stocks just because you're retired. Yes, the market can be volatile, and there are some risks involved. But if you're talking about money you won't be needing for quite some time, you can come out ahead by using it to generate returns.
Here's another way to look at it: The stock market has historically delivered a 9% yearly return, whereas interest rates today on savings accounts and bonds are pitiful at best. Now let's say you're sitting on $500,000 in savings, $400,000 of which you don't expect to need for a good seven years. If you leave that money split between cash and bonds, you might average a 2% average annual return during that time, leaving you with a total of $59,000 in growth. Now that's not bad, but watch what happens when you put the bulk of that money in stocks for an average annual 7% return (which, if you'll notice, is below the market's average). Rather than see $59,000 in growth, you'll have $242,000 in growth.
Now obviously, you won't get to reap that entire benefit in 2018, but what you will do is increase your nest egg so that you have more income available in general. Should you choose to cash out some of your gains in the upcoming year and use that cash for other purposes, you'll see less growth in total (not to mention you might lose a portion to taxes) -- but you will have more flexibility to live the lifestyle you choose. Better yet, if you happen to invest in dividend stocks, you'll have income coming in quarterly, which can buy you more options in the near term.
You deserve to enjoy a host of experiences in retirement, and the more income you have, the greater your chances of doing just that. Make a few key strategic moves, and with any luck, you'll reap the benefits of a wealthier 2018.