Individual Psychotherapy and Counseling: When to Seek Help
In our daily lives, we all face struggles, both large and small. We experience anxiety and extended periods of sadness and low energy. We work on our experiences, pull friends close and try techniques that have worked in the past. Sometimes it’s different though. Sometimes the struggles are beyond our skillset to negotiate. Sometimes we’ve had such a hard series of hits that our normal resources and social supports aren’t enough. That’s when it’s time to reach out for help.
The key to a happy, satisfying life is the ability to move through those times of challenge and develop new capacities without getting stuck. Sometimes you need a skillful listener to help clarify your thinking. Sometimes, you need an insightful perspective. Sometimes you’re facing a pattern of struggles that link back to childhood wounds and limiting beliefs about ourselves, others and life itself.
At those times when old beliefs and feelings get triggered by real life events, it’s easy to get overwhelmed, confused or lost in them. You need someone to step in and give you a hand. There’s where I come in. By bringing a compassionate, non-pathologizing approach – along with extensive training in several therapeutic modalities – together we bring caring, insight and integrations to help you grow from the struggles you face.
What are the benefits of individual therapy?
- The benefits of therapy vary based on your issues and your motivation. But generally speaking, in our work together I can help you:
- Develop greater emotional resilience
- Increase your self-awareness and nonjudgmental self acceptance
- Improve your relationships with loved ones
- Let go of limiting patterns and past traumas
- Feel more alive and passionate
- Develop more clarity and purpose in how you think, feel and act
Issues I can help you address:
I have successfully helped men and women grapple with everyday – and not so everyday – life issues, including:
- Depression, loneliness and loss
- Anxiety, worry and stress
- Self-esteem issues
- Obsessive thinking and compulsive behavior
- Interpersonal conflicts and anger in marriage
- Intimacy and relationship challenges
- Addictive behaviors – from the internet, to substances and sexually compulsive behavior
- Life transitions – including divorce, career changes, family building and a failure to thrive
- Parenting support – from toddlers to teens to young adults
- Career-related frustrations and concerns
- Psychological challenges of wealth and success
- Coping with Attention Deficit Disorder in yourself or you family
Although these issues are common with many of my clients, every person I see is unique, with unique strengths and challenges and requires a unique intervention. Together we come to a common understanding of your challenges and goals. Together we create a treatment plan responds to these immediate and long-term goals. Then together we sort through the thoughts, feelings and needs that will get you to where you are wanting to go. Using my years of training and experience we achieve the positive and sustainable change to meet the challenges you face.
Who I work best with:
Our success relies heavily on the quality of our partnership. I tend to work best with people who, along with wanting short-term solutions and symptom relief, also want to better understand their feelings and behavior so that they can make lasting changes in the way they feel about themselves and relate to others. People who are willing to compassionately question past assumptions and experiment often reach their goals easier. When you are willing to examine your life and have a desire to change the ways you react and think about parts of it, you have a very good chance of success.
If you’re mainly interested in short term coping mechanisms for controlling your thoughts, feelings or behavior without experimenting or understanding more about yourself, we’re less likely to be a good fit. You might consider medication. If you don’t get the desired results from medication, you might try hypnosis, solution focused brief therapy or dialectical behavioral therapy.