E. Marcus Davis Has Prosecuted Over 100 Traumatic Brain Injury Cases
Cases have ranged from mild to catastrophic for brain injury survivors.
His knowledge about brain injuries allowed him to help clients whose cases might not have been considered by other less informed lawyers.
Using his expertise in this area, he published “Mild to Moderate Brain Injury – A Silent Epidemic Needing to be Heard” in the magazine of the Georgia Trial Lawyers Association, The Verdict, published “Mild to Moderate Brain Injury” in the magazine of the Association of Trial Lawyers of America, Trial Magazine, and has co-chaired numerous seminars on the subject of brain injuries for lawyers.
In 2000, he was co-chairman in the annual fundraising campaign for the Brain Injury Association of Georgia. The article and seminar instructed attorneys in the field on the emergence of new diagnostic tools being used by neurologists and neuropsychologists and the importance of previously ignored symptoms of brain injury.
Traumatic Brain Injury Symptoms
An experienced trial lawyer should recognize a mild to moderate brain injury case even when the client arrives undiagnosed. Often, the client may experience dizziness, overwhelming fatigue, vision problems, concentration problems, memory problems, mood swings, and even depression.
Recognizing some of the signs and symptoms of traumatic brain injury and making sure that the client’s treating physician refers the brain injured person for proper diagnostic evaluation is part of the obligation of the trial lawyer in this field.
A good personal injury lawyer should concern himself with obtaining appropriate specialized medical help for his clients while also fulfilling the more traditional lawyer’s role of helping clients obtain full and fair compensation for of their injuries, physical, mental and emotional. After all, a lawyer should serve his client not only in the court room, but also as an advisor to the client who has just experienced tragedy and needs the appropriate medical care in order to recover as quickly as possible.
To maintain his expertise in traumatic head injury cases, Mr. Davis attends seminars across the country on brain injury, and, over the years, has attended many traumatic brain injury support groups. He also belongs to and donates to the Brain Injury Association of Georgia and served as co-fundraising chairman in 2000. Through many cases, Mr. Davis has acquired a wealth of brain injury textbooks, articles, and demonstrative exhibits that he uses to keep his knowledge in this field fresh as well as to educate clients, judges, and juries in this complicated area of medicine.
For a more exhaustive review on the subject please refer to the following articles and essays.
Traumatic Brain Injury Articles:
- “Mild to Moderate Brain Injury: A Silent Epidemic,” Trial Magazine, 1990.
- “What a Professional Needs to Know About Traumatic Brain Injury,” 2008
- “Proving Damages in a Traumatic Brain Injury Case“
- “Demonstrative Evidence in the Catastrophic Brain Injury Case,” by Thomas William Malone & Bob L. Shepherd, MS, CMI
Traumatic Brain Injury Case Resources:
- American Academy of Neurology
Review of neurological conditions and neurology related links.
- American Association of Neuroscience Nurses
Organizational information and links to other neurological sites.
- Brain Injury Association of America
Provides education, advocacy and support for those affected by brain injury.
- Brain Injury Association of Georgia
Provides education, advocacy and support for those affected by brain injury.
- Brain Injury Association of Georgia Info & Resources
FAQs and a directory of brain injury services and resources in Georgia
- Brain & Spinal Injury Trust Fund Commission
The Brain and Spinal Injury Trust Fund Commission enhances the lives of Georgians with traumatic brain and sponal cord injuries by administering the central registry, distributing resources through the trust fund, and advocating for improvements in statewide services.
- Brain Injury Research Foundation
Where people affected by brain injury find answers to questions, resources, and a caring community.
- Centers for Disease Control (CDC)
-.
- Cerebral Palsy Directory
Compendium of Cerebral Palsy related resources.
- Georgia Advocacy Center
The Georgia Advocacy Office (GAO) works with and for oppressed and vulnerable individuals in Georgia who are labeled as disabled or mentally ill to secure their protection and advocacy.
- Global Brain Stem ’97
University of Wisconsin Medical School’s online textbook.
- Hydrocephalus Association
Organizational information and newsletter articles.
- Institute of Neurotoxicology and Neurological Disorders
Consumer health resources for neurological disorders.
- Journal of Neuroscience Online
Searchable database with full text on abstracts.
- Malignant Brain Tumors and Neuro-oncology Resources
Massachusetts General Hospital Harvard Medical School site with information and links to other neurological resource sites.
- Medical Matrix – Neurology
Neurological news, articles, abstracts, diseases, patient education and more.
- Ntl. Assoc. of State Head Injury Administrators
Assisting state government in promoting partnerships and building systems to meet the needs of individuals with brain injury and their families.
- The National Institute of Neurological Disorders and Stroke
A searchable site with information on selected neurological disorders.
- Neurosciences on the Internet
Searchable database and links to resources.
- Neuro Trauma Law Nexus
Resource for understanding the legal system’s involvement in brain and spinal cord injury cases.
- Society for Neuroscience
Publications of the Neuroscience Society.
- The Virtual Hospital: The Human Brain
7BrainAnatomy.html
Online textbook with images of dissections of the real brain.
- Whole Brain Atlas
Searchable site with images of various medical conditions and a neuro-imaging primer.