Do you have a blind spot driving your business issues?
“It isn’t what we don’t know that gives us trouble, it’s what we know that ain’t so.” – Will Rogers
I’m pretty sure we all carry around head trash – things that we believe that aren’t actually true. Of course since we believe it, it never crosses our mind that it might not be true – essentially it’s a blind spot.
The problem with head trash or a blind spot is that it can make things harder than they need to be…or even potentially make it impossible to succeed. We look at data, analyze options and make decisions – all without realizing that we’re using a filter that’s keeping us from seeing the real picture.
Let me give you an example – I’ve talked to 3 different business owners in the last 2 weeks and although they were in very different businesses and industries, all 3 of them shared a crippling problem that was rooted in head trash.
They all believed that they cannot charge any more for their product / service than what they are currently charging.
Maybe they’re right – they may be priced exactly in line with the marketplace for what they’re offering.
However – even if that’s true (which I don’t think it is) – that leaves them with at least 2 major problems.
Problem #1 – they aren’t making enough money
If they’re right and they absolutely can’t charge anymore than they are today, then their business model is broken. They are struggling, working way too many hours and doing too many things themselves because there isn’t enough money flowing to the bottom line for them to be able to scale in a healthy way.
When you have a business that can’t generate enough to cover all of your costs (including a market based wage for you as the owner) plus a healthy profit margin of at least 10%, then you have a business that’s on life support. You may be able to limp along indefinitely, but it’s really hard going and any kind of negative surprise will immediately put a lot of pressure on you financially.
The lack of profitability makes it impossible for you to build up reserves and weather downturns.
Problem #2 – they aren’t different enough
If they are priced exactly in line with whatever else is out there, customers will perceive their product or service as being essentially the same as the competition. When customers have choices, and everything looks the same, then they will make their choice based on price. A losing scenario any way you slice it. Either you’re going to lose out on opportunities because your competition decides to undercut your pricing…or you’re going to lower your pricing to get the business, which leads us back to problem #1…you aren’t making enough money as it is.
You’ve got a blind spot putting a cap on pricing with a side effect of selling a product that looks like everything else out there.
How do you break the blind spot?
Unfortunately, blind spots are hard to break. By definition, you don’t recognize that you have an issue. You have a firm belief in something that isn’t true – and that firm belief will keep you from questioning things that need to be questioned.
That said, there are a couple of things you can do that will help.
1. Get some outside perspective
One of the biggest advantages of an outside advisor…like maybe a business coach?…is that they are less likely to share your blind spots. They don’t have the emotional attachment and they have worked with other businesses and have a broader view of what’s possible.
But having an outside advisor only works if you are actually open to their ideas. You don’t have to agree and act on everything or even anything they say, but you do need to be willing to consider any new ideas they bring up.
2. Think about your business as a Science Project
If you approach your business as a lab experiment, then it’s perfectly natural to try new things, in a controlled fashion. If you believe that your pricing is as high as it can go, but you need to make more money, then try an experiment and change your business model and your pricing and see what happens. How could you add value, change the perceptions of what you offer…and charge more? Come up with a new variation and try selling that for the next month or two and see what kind of response you get. Maybe raise your price for a specific area or product as a controlled experiment.
Constantly be looking for ways to learn new things and let the data drive where you go next.
Just being aware that you might have some blind spots will help you mitigate the risk – but it’s a constant battle and you’ve got to be always on the lookout for believing things that might not be true.
Are you aware of any blind spots that you’ve got? Or maybe something you’ve overcome in the past? How did you break out of it? We’d love to hear your thoughts.
Shawn Kinkade Kansas City Business Coach