Exposing fossil fuel 'externalities'
Meanwhile, Rome (and the rest of the world) continues to burn. (GW)
Looking at the real cost of fossil fuel
HYANNIS
Imagine an economic report that proposed to lower the price of milk by deregulating water pollution from dairy farms; or to make aluminum more affordable by letting corporations pile up mine tailings and emit toxins from smelters without consequence.
No economic study that proposed to ignore such an integral (and expensive) aspect of doing business could ever survive peer review. Nor could its author win tenure.
So why should we accept economic studies that take exactly this approach when analyzing the cost of energy — including, for example, recent critiques of the Cape Wind contract now under review by the Massachusetts Department of Public Utilities? Cape Wind is the 130-wind-turbine project proposed for Nantucket Sound.
Almost 85 percent of all electricity purchased in Massachusetts last year was generated by fossil fuels. The price Massachusetts ratepayers paid for that electricity was certainly higher than for consumers in most states, but because of massive subsidies enjoyed by the coal, oil and gas industries, it was far below the actual cost of generating that power.
We aren’t talking about the billions of dollars in taxpayer subsidies that energy-industry lobbyists wring out of Congress each year — although that’s bad enough. Rather, we are talking about environmental subsidies: devastation in the Gulf, mountaintop removal in Appalachia, acid rain and mercury poisoning of every lake and stream on the East Coast, and — potentially the greatest price of all — a warming globe.
If these impacts were priced into the total cost of energy, as they should be, pollution-free renewable resources like Cape Wind would be among the most cost-effective generators of electricity available and state ratepayers would be screaming to build it now.
But we exclude such costs, in large part because our economists tell us to. They, of all people, should know better.
In economics, conduct that re-allocates part of the cost of doing business upon other parties without their consent (such as pollution of public air and waters) is called an externality. To the extent that environmental impacts are not reflected in the market price of electricity, consumers are not paying the full cost of that power (i.e., their energy use is being subsidized), and energy markets become distorted, resulting in inefficient use of resources.
Which is to say, our electricity is only cheap because we are forcing someone else — in large part future generations — to pay a lot of the true price. In terms of global warming, the massive emissions of carbon dioxide (CO{-2}) from fossil-fuel energy production is widely recognized by economists as an externality par excellence. Carbon-dioxide pollution emitted by coal and oil-fired power plants distributes evenly throughout the global atmosphere, damaging everyone’s air quality and threatening our climate — the world’s most precious public good.
Such pollution is anything but free. Our climate systems are already undergoing well-documented changes — sea-level rise, increasing extreme weather events — which will impose billions of dollars in damages in the short term and may devastate entire economies (and countries) over time.
Cape Wind Associates and other renewable-energy developers have shouldered the costs of figuring out how to produce electricity without emitting CO{-2} and other pollutants that contribute to global warming. But renewable-energy entrepreneurs cannot reap the full market benefits of producing low- or zero-emissions energy so long as fossil-fuel energy providers are allowed to pollute with impunity.
This environmental subsidy gives energy companies that externalize their pollution an enormous and wholly unfair competitive advantage — and an irresistible incentive to pollute.
Even worse, the market distortions this creates are leading to wrongheaded investments. New energy infrastructure, such as a gas power plant or wind farm, is extremely expensive and therefore tends to be long-lived. Investments based on distorted market conditions that favor fossil-fueled power plants, as now, will only lock in increased environmental degradation for many decades to come. As a consequence, the environmentally benign technologies, such as a wind farm, that we need to stop acid rain, mercury poisoning and prevent offshore drilling (and beat global warming) could be locked-out.
Thus, the most critical time to evaluate the complete and true cost of energy is at the investment stage. From this perspective, the state Department of Public Utilities should recognize that pollution-free energy from Cape Wind is not just a good deal — it is also urgently needed to help wean us from prior energy investments that (wrongly) assumed an unabated right to pollute forever.
If we are to make the right investments, our economists have to tell the whole story.
Barbara Hill is executive director of Clean Power Now. Matthew Pawa is a lawyer who represents Clean Power Now as an intervenor in the Department of Public Utilities proceeding on Cape Wind.