ATF additives can alter automatic transmission fluid properties, causing degraded low-temperature performance, premature wear, corrosion and shudder problems.
Original equipment manufacturers (OEMs) perform extensive testing to determine the lubrication characteristics required for specific transmission designs and applications. OEM engineering specifications outline the physical properties and minimum performance levels of the required fluids, and only a well-formulated automatic transmission fluid that meets these OEM specifications ensures proper transmission function and maximum service life.
In the past, a few major OEM specifications covered the transmission fluid requirements for the entire industry. Today, numerous different specifications have led to confusion and inconvenience for consumers, especially for those who own vehicles from different manufacturers. Installers face similar issues; keeping an inventory of different fluids may be confusing and expensive. To simplify matters and reduce costs, many transmission fluid installers rely on ATF additives to fortify used fluid, “update” less expensive outdated fluid or add an extra level of protection. In fact, a recent study revealed 53 percent of surveyed shops used additives to enhance “DEXRON®/MERCON®” ATFs.
Claims by ATF additive manufacturers lead consumers to believe the additives provide everything transmissions need to perform well and last longer. Despite such claims, however, most vehicle and transmission OEMs specifically warn against using them. Not only are the benefits usually short-lived, but the additives can actually degrade the performance of the automatic transmission fluid.
The following test data from industry studies demonstrates the shortfalls of a typical ATF additive in three critical performance areas. The data also identifies a situation where the ATF additives degraded the performance of the original fluid enough that it no longer met the requirements of the specification for which it was designed.
Frictional Performance
To function properly, the friction surfaces in an automatic transmission and locking torque-convertor must slip enough to engage smoothly and then firmly lock to transmit power without slippage. Well-formulated automatic transmission fluids contain carefully designed friction modifier additives that effectively promote this process over the recommended fluid life. If the required frictional performance level is not met, the clutches and other friction surfaces slip and lock intermittently under load, causing shudder that contributes to inefficiency and potential transmission problems.
ATF additive manufacturers attempt to address shudder issues by formulating their products with highly frictionmodified additives. As the modified SAE Severe Anti-Shudder Durability test (Chart1) shows, ATF additives may initially boost anti-shudder performance, but the benefit is short-lived. In less than an hour, the anti-shudder performance level of the base ATF treated with an ATF additive began to decline, and within 1.5 hours fell below the minimum performance reference line. In contrast, the ATF without an ATF additive maintained its ability to resist shudder for close to six hours.
Wear
The FZG Wear Test (ASTM D-5182) is used to gauge resistance to scuffing loads common in automatic transmissions. At each stage, a progressively heavier load is applied to a set of gears, and scuffing of the gears is evaluated. The lubricant protecting the gears will either pass or fail the load stage based on this evaluation.
The negative effect ATF additives can have on transmission fluid is clearly demonstrated by the test results (Chart 2). While the untreated DEXRON IIIH/ MERCON transmission fluid produced an FZG pass rating of 10, the addition of an ATF additive interfered with the original fluid’s designed protective properties and lowered the rating to 9. In contrast, AMSOIL Synthetic Multi- Vehicle Automatic Transmission Fluid produced an FZG pass rating of 12, surpassing virtually all OEM specification requirements.
Cold-Temperature Performance
Vehicle manufacturers specify maximum cold-temperature transmission fluid viscosity limits to ensure adequate lubrication at startup and proper shift performance in cold weather. The Brookfield Viscosity Test (ASTM D-2983) is used to measure fluid viscosity at low temperatures. A measurement at -40°C ATF additives can alter automatic transmission fluid properties, causing degraded low-temperature performance, premature wear, corrosion and shudder problems. M A G A Z I N E JANUARY 2011 | 9 (-40°F) is a common transmission fluid specification requirement, and the result of the test is expressed in centipoise (cP). The higher the cP, the more the fluid resists flow.
The maximum Brookfield Viscosity limits at -40°C for four OEM transmission fluid specifications are indicated in Chart 3. The untreated DEXRON IIIH/MERCON transmission fluid alone met the DEXRON/MERCON Brookfield Viscosity requirement. However, when an ATF additive was added, it failed to meet the requirement, demonstrating clear evidence of ATF additives negatively interfering with the properties of automatic transmission fluid. AMSOIL Synthetic Multi-Vehicle ATF meets the Brookfi eld Viscosity requirements of all the specifications displayed in the graph, demonstrating that a premium-quality, multi-vehicle transmission fluid is the optimal choice when a single product must satisfy the requirements of multiple specifications.
Recommendation
AMSOIL INC. recommends against the use of ATF additives as they may cause a reduction in performance, protection and longevity of equipment, and can ultimately cause permanent damage to a vehicle’s transmission. The use of any aftermarket ATF additive will void the AMSOIL Limited Warranty.
AMSOIL Synthetic Multi-Vehicle Automatic Transmission Fluid (ATF) and Synthetic Fuel Efficient Automatic Transmission Fluid (ATL) are highquality transmission fluids engineered to the highest performance requirements of multiple transmission fluid specifications. AMSOIL transmission fluids are multi-vehicle products that accomplish the objective of additives without degrading performance. They effectively reduce confusion, inventory requirements, misapplication and cost, while providing superior protection to help extend transmission life. AMSOIL ATFs are warranted by AMSOIL for use in a wide range of domestic and import vehicle transmissions.
