Calum Malcolm, Chief Technology Officer at Timico says the very heart of networking is about to change and here he explains how SDN works and its likely impact on the channel.
Over the last few years we have seen a revolution in how computing services are delivered. ‘Cloud’ and ‘Virtualisation’ have changed the way we consume our applications, however the underpinning Network which services these platforms has evolved very little.
The network infrastructure is the platform that applications and communications services rely on in today’s environment. It is made up of several physical elements such as routers, switches and firewalls, but in essence works as a single entity. The interdependence of these elements is complex, which makes any change or development a fairly risky task.
Software Defined Networking
SDN is a network architecture that fundamentally changes how we design, manage and operate an entire network so that modifications to the network become practical and reliable.
Today’s network switches and routers program their forwarding tables locally, meaning network devices make their own decisions internally about how to forward traffic. Every time a service is added, the devices have to be individually configured by skilled engineers. Traditional networking protocols have limited flexibility and in order for them to work, all participating network devices need to have the same rules configured. This means that complex or unusual requirements become difficult to deploy in a risk-free way.
A network device will forward data based on the configuration of its control element. SDN separates the control element from the network device – the intelligence which determines how the data is handled and separated from the physical elements of moving the data. The complex control intelligence is then held on a centralised controller that understands the complete topology of the network. This omniscient central controller allows engineers to implement unique and flexible routing policies limited only by the ability of the software running on it. It also enables unskilled operators to deploy complex service via a portal quickly and without risk, reducing deployment times significantly.
Network Feature Virtualisation
In addition to SDN, there is also Network Feature Virtualisation (NFV). NFV is often considered to be a part of SDN but is really a complementary technology which depends on SDN to deliver its benefits.
Network Feature Virtualisation is focussed on network appliances such as logging, monitoring, capture, content analysis, security control and other similar functions. These functions are typically end user equipment such as routers and firewalls. Effectively, dumb boxes can be deployed to end user sites and features configured as needed via the centralised portal. This means complex devices no longer have to be preconfigured and shipped to site which rapidly speeds up deployment, meaning it can be done on demand in minutes rather than days.
Current landscape
Many networking vendors have been hard at work producing custom APIs that leverage the full feature set of their network hardware. Juniper have their Contrail offering which provides access to SDN and NFV. Cisco has developed the Cisco Open Network Environment (ONE). The Cisco approach differs to Junipers but in effect they have the same end result.
There are also several “open source” solutions, such as the Open Daylight Project, which are platform agnostic utilising open standards such as Open Flow to deliver services.
The current drawback for communication providers is the slow progress in the development of SDN within the larger carriers. The way they currently provide services such as Ethernet slows down progress in deploying SDN and NFV. However Talk Talk are leading the way. Talk Talk have recently deployed a Juniper end to end network with the Contrail product and most importantly have opened up the APIs to the community to ensure SDN and NFV functionality can be accessed. This makes it easier for mid-range suppliers to become SDN enabled end to end.
Future
There will not be an overnight move to SDN but it will be progressive – over the next few years the availability will revolutionise the way networks are delivered. Not only will the configuration and deployment of services be simplified, we will start to see cloud applications inherently have the ability to configure the Network automatically, on the fly, as they themselves are deployed.
Network Providers will be able to speed up delivery of complex services and effectively reduce lead times of complex configurations and services significantly (excluding of physical fibre installs) via these portals. This will not only benefit the providers but also the consumers of these services who, in time, will be able to switch on and turn off complex applications and network services via these new portals.
I believe the way the Cloud has revolutionised our utilisation of computing and applications, will be similar to what SDN is set to do for the Network. Easing deployment, increasing flexibility and enabling control to the end user. It’s the beginning of an exciting journey.