Sensors and actuators are taking the next evolutionary step and forming integrated systems
Smaller, cheaper, faster, cleaner, smarter. The demands in industry today are many. And only a combination of mechanics and electronics can deliver them. On a miniature scale, this combination is known as microelectromechanical systems or MEMS.
When MEMS technology first surfaced, it quickly grabbed the attention of the engineering community. Many thought it would be a short time before this technology affected almost everything. But it hasn't quite worked out that way.
MEMS-based sensors are progressing well from research and development to commercialization. They are often found in office products such as ink-jet printers and hard disk readwrite heads. In automotive applications, they're combined into systems containing micro-actuators and circuits to control the activation and deployment of almost all air bags. And in medical applications, they can be found in a host of devices from pacemakers to hearing aids.
MEMS-based actuators, however, have not made the transition from research to commercialization as quickly. Part of the reason lies with the difficulty in building MEMS engines with sufficient torque, and in joining tools to them. Another reason is the need for new fabrication techniques that permit batch production.
As researchers overcome these hurdles, actuators grow more commercially viable. In fact, new applications are beginning to appear, from microrobotics and noncontacting wafer transport systems to ultraprecise positioning.
The single state
Government research labs and facilities, such as the Microelectronics Development Laboratory at Sandia and Berkeley Sensor and Actuator Center (BSAC), have been instrumental in developing new fabrication approaches that boost torque and lessen the difficulty of connecting tools to MEMS devices. Some of the promising techniques include multilevel polysilicon micromachining and single-level polysilicon structures machined on CMOS substrates.
Polysilicon micromachining is a thin film process. Each material layer is four microns or less in thickness. Typically, layers of material are added to a substrate structure one at a time. Before the next layer is built, though, the previous layer undergoes any photoresist, exposure, and etching steps.
Until recently, microstructures usually used one layer of polysilicon. The latest sensors and actuators are built with four layers of this material and undergo eight or more masking steps in a process known as multi-level polysilicon micromachining. Three of the layers are movable polysilicon separated by layers of oxide.
For example, researches at Sandia Labs can make an electrostatic comb drive from one layer of mechanical polysilicon and a ground plane. With another layer of polysilicon, they can create a gear mechanism that rotates about a hub, as well as out-of-plane mirrors with hinges. By adding a third layer and "planing" away a sacrificial oxide layer, they were able to form linkages between actuators and output gears. These gears can rotate at speeds over 300,000 revolutions per minute.
The planing process, known as chemical mechanical polishing (CMP), is a type of annealing that is usually used on the upper layer of polysilicon on a structure. An abrasive slurry smoothes the polysilicon surfaces, both top and underside, removing excess features that would interfere with the movement of bearings and gears formed in other layers.
This process lets researchers create complex monolithic structures, such as interlocking gear trains and adaptive optical systems, that combine logic, drive, and signal processing electronics with micro-mechanical devices. Such devices are expected to replace the multi-chip format of past MEMS devices.
By combining these functions, today's MEMS devices possess intelligence and the capability to handle multiple tasks. An intelligent micromachine, for example, can signal for more power, indicate whether it's operating too fast or too slow, and automatically execute software routines. Such systems-on-chips include combination locks used to protect networking equipment, pop-up mirrors recently introduced for fiber-optic communication, and multi-axis accelerometers.
Researchers continue to experiment with additional layers of polysilicon, sacrificial oxide, and CMP steps. For example, with a fifth layer of polysilicon and a second CMP process, researchers created a gear train with moveable platforms.
A new union
The other MEMS processing technique, which combines polysilicon surface micromachining with CMOS, is being used to produce sensors and microelectronic control circuits on single-layer chips. By integrating control circuitry on a MEMS device, researchers can reduce parasitic noise associated with low-level stimuli at the interconnections.
Sandia's technique for combining CMOS and surface micromachining is to first make the MEMS components, then continue with conventional CMOS processing on the same wafer. The micro components are made in a trench etched into the wafer surface. Once done, the trench is backfilled with oxide as needed. The oxide bridge helps metal layers across the uneven surfaces of the two parts of the device.
Continue on Page 2
Using this method, BSAC developed an inertial measuring sensor that measures six degrees of freedom. It has a three-axis accelerometer and an XYZ gyroscope for navigation. The sensor measures less than 1 cm2. Other devices that use IC-based packaging include Hall and magnetoresistive sensors, and silicon accelerometers.
And many MEMS devices are still fabricated using more traditional techniques, such as LIGA. This German acronym roughly translates as lithography, electroplating, and molding. The fabrication steps include X-ray exposure of a resist material, plating, and then the removal of more resist until developers reach the desired microstructure.
Still to come
The remaining barriers to the expansion of MEMS include a lack of standard testing methods, a definition for acceptable reliability, standard packaging formats, and competition with existing technologies.
So far, testing equipment and methodologies have been specific to the developer of the micro device. Because each manufacturer tests for different attributes, it's often difficult to evaluate differences among various devices.
The same is true of performance measurements. There are no definitions that spell out minimum acceptable performance or reliability levels.
Most approaches to packaging are also company specific because they are seen as competitive advantages. This situation is especially prevalent with European developers. Apparently, the development community is waiting for users to set the standards.
Many interested parties, though, fear that the lack of agreement on size, height, and other form factors will retard industrial and commercial growth.
And lastly, work must still be done on linking micro devices to the macro ones we're all familiar with. So, although there's been progress, it may be a few more years before MEMS technology fulfills its initial promise.