Ayatollah Ruhollah Khomeini once famously said: "Economics is for donkeys." Well, looking at the economy of Iran today it is clear that Iran could do with some more donkeys, in the guise of economists. Iran has perhaps the largest combined oil and gas resources in the world. It has about 980 trillion cubic feet of natural gas, and about 132 billion barrels of oil. One cannot say that Iran is a resource-poor country, but it is a resource policy-poor country. The increasingly "conservative" yet risk-taking leadership is driving Iran's economy into the mud.
A major reason behind this is the huge subsidization for gasoline, diesel fuel, and electricity. Energy subsidies may represent as much as 15-20 percent of GDP, or about $35-40 billion per year. Iran also imports one-third of its gasoline needs to the tune of about $4-5 billion per year. The cost of gasoline in Iran is about 40 cents per gallon. This has prompted a huge and increasing demand for gasoline, well beyond what it would be if the price were in tune with the higher cost Iran pays for its gasoline.
The gasoline subsidy is also an indirect subsidy to Iran's automobile industry, which is pumping out 1 million cars a year into the already clogged streets of Tehran, Isfahan, and other cities. The auto industry employs about 500,000 people. So the argument goes that Iran should keep them employed at huge costs to the country's fragile economy.
Each one of those auto jobs likely costs Iran many times the productivity of each of the workers employed. It would make more sense to move auto workers to more competitive industries. But that's not in the cards.
Subsidizing gasoline and the auto industry has lead to vast increases in air pollution and subsequent health problems, especially in Tehran. So we must also factor in the health effects and costs of such subsidies.
Another cost is the "opportunity cost" of the money for subsidizing and importing gasoline and subsidizing the non-competitive auto industry.
Those funds could be going toward developing Iran's severely underinvested oil and gas industries. Maybe the donkeys are right.
Iran has part of the largest natural gas field in the world - what Qatar, which shares the field, calls the North Field, and what the Iranians call South Pars. About half of Iranian natural gas can be found there. Most Iranian oil is located in the southwest of the country, and there are very large new oil fields that have been discovered in the last few years, yet that have not been developed. One of the reasons behind this is the imposition of strict constraints on outside investors: Due to very limiting buyback contracts, investors cannot share in the production and management of the oil fields that they develop.
As an example of the misdirection of resources, take the case of the Oil Stabilization Fund. The fund is designed to stabilize the budget by moving funds from high oil price years to low oil price years. However, it is often ransacked to pay for energy subsidies and gasoline imports. Yet by investing some $75 billion - or just over two years of energy subsidies - Iran could vastly increase its oil production to around 6 million barrels a day from its current 3.9 million barrels a day. For about $85 billion - or two and a half years of energy subsidies - it could bring up to speed its liquefied natural gas trains, pipelines, and production capacities.
Iran also "flares," or burns into the atmosphere, about 7 percent of its natural gas. This is way above the world average, and is a huge waste of resources. Some believe the electricity that could be produced from this flared gas would be equal to about three Bushehr nuclear power plants.
Iran's development of the entire nuclear fuel cycle, not just nuclear power plants, is another misdirection of resources that could bring huge risks to Iran, even destruction. This process will cost tens of billions of scarce revenues. Not even the United States has developed the full fuel cycle.
Arguments that nuclear power is cheap get weaker when we divide the costs of developing the entire nuclear fuel cycle over each bit of electricity produced. Also, Iran has few uranium reserves. Reasonable estimates are that, given a 3,000 to 4,000 megawatt capacity for electricity production, Iran may have five to eight years of uranium in its own reserves. This has to be enriched, built into fuel pellets, put into fuel rods, and so forth.
Iran's argument for nuclear power is that it will have greater energy independence. How does that work when it will need to import uranium for its fuel cycle fairly soon? Another Iranian argument is that if it increasingly produces electricity with nuclear power, it can export more gas and oil. This would be a stronger argument if the Iranians first developed their oil and gas fields. But why set up the entire fuel cycle now, with all the political tensions this has produced and will continue to produce? Why not just develop the nuclear electricity plants, which Iran can do under the nuclear Non-Proliferation Treaty? Iran hid some of its nuclear facilities for years, until an opposition group let the cat out of the bag. Why hide those facilities if there was nothing to hide?
Iran is engaged in a terrible misuse of its resources. There seems little sense in subsidizing the nuclear industry, imports of gasoline, the auto industry, overall energy, and more, in a country that must make sound economic decisions on every issue, every day, in order to make its people better off. Economics is not for donkeys. It is for development, prosperity, and peace. It's time for Iran's leadership to smell the coffee and start developing their country, so it gets along better with its neighbors and the world. The leaders claim to exist for their people. I wonder.
Paul Sullivan is a professor of economics at the National Defense University and Georgetown University, both in Washington DC.