Whereas generating plant provides energy [MWh], it must in addition provide power capacity [MW] essential to maintain security of supply at times of peak demand. The current market arrangement deals in energy only. So it is not surprising that considerable concern is now being expressed about the ability of this arrangement to deliver sufficient power capacity at times of peak demand and ensure security of supply. With large subsidies for wind generation, the current arrangement results in higher than necessary electricity prices to customers.
A trading arrangement that includes both power capacity payments (based mainly on capital expenditure) as well as energy payments (based mainly on revenue) is needed. Incentives to generating companies to build high capital cost plant should be provided, thus achieving an overall minimum cost for both energy and power to the customer for an acceptable risk to security of supply.
Constructing an arrangement of competitive tenders for long-term contracts for both energy and capacity combined is the obvious way forward. The long-term requirement is necessary to reflect capital commitment to plant that has a 40-60 year design life. The energy (revenue) component price need not be fixed – many energy contracts have escalation clauses related to indices for fuel, salaries etc. One option would be to have a standing commission (reporting to Parliament) to decide when generating plant of a particular type is required to meet a specified standard of security of supply. The commission would then arrange for tenders to provide this plant. The issues of both plant mix and risk to security of supply are then raised together.
Current arrangements are unnecessarily complex, involving electricity price auctions and prior contracts between buyers and sellers rewarding either according to the actual price on the day. In addition, these overlay a “market” that includes overt subsidies such as renewable obligation certificates and feed-in tariffs and accompanying covert subsidies for system integration costs from intermittent renewable generation. Surely a degree of “central planning” would be preferable? Because of the shape of the demand curve, a mixture of low running cost/ high capital cost plant and the opposite is required to achieve an overall optimisation of cost to the customer. An energy only “market” will not achieve this. All customers pay for this unsatisfactory situation.
Britain is in a difficult position regarding the risk to security of supply. The previous risk standard was to accept failure to meet maximum demand in no more than four winters in 100 years, but this was abandoned with privatisation. Instead reliance was placed on incentive payments to a pool of generators to reduce the probability of loss of load, a cost/benefit arrangement.
The subsequent introduction of the full electricity market system based on energy costs only has proved a step too far. A return to a risk-based standard to which the standing commission would work is needed.
If established, the commission should examine requirements for all types of new plant at least seven years ahead and recommend Parliament commission accordingly. For a system comprising thermal generating plant, an operating plant margin 20 per cent greater than the best estimate of maximum demand for the coming winter is required, to meet the pre-privatisation standard of risk.
However, looking seven years ahead, a plant-planning margin of 28 per cent would be required in order to accommodate increasing uncertainty with time. For a system including intermittent generation, such as wind, a much higher figure would be required, with wind generation requiring more than 90 per cent back-up generation capacity from open cycle gas turbines.
It would be poor engineering practice to rely on a less than fully trial-led arrangement of smart metering to contain demand and the risk to security of supply. Until tariffs reflecting the long-run marginal cost at specific times are available, it is unlikely that smart meters will have much effect on customer use.
The current wholesale energy “market” is less than efficient. It is distorted by subsidies and other costs which should go through the market but which do not. Perhaps worse is that one corporate body can hold both a generation and a supply licence. Licence holders can despatch their own electricity to meet their own contracts, thus relegating electricity price competition to the negotiating interface between suppliers and customers. Because the generator/supplier has much better data and negotiating skills, the customer effectively loses out.
There is a great need to replace the existing arrangement with one that will optimise the combined cost of both energy and capacity to meet a specified standard of security of supply.
• Colin Gibson of Scientific Alliance Scotland was Power Network Director, National Grid Group 1993-97
SEE ALSO