How to create an upload of a document to Excel via a form, then upload it to Google Disk and download it in PDF format
The operation is implemented through a chain of calls to External Actions.
Generate Excel - > Upload a file to google drive - > Export to PDF
1. Create a form with the settings of the upload parameters and call the external action generatedoc, also specify the spCallback for export after generating the document.
-- SELECT 2 в SaveItem -- SELECT 1 (Result, Msg, SuccessUrl, HideFormAfterSubmit, RefreshContainer) select 1 Result, ' ' Msg, '' SuccessUrl, 1 HideFormAfterSubmit, '.stageDocs' RefreshContainer -- SELECT 2 Calling an external action select 'generatedoc' type, 'stageAct' code, cast(@itemID as nvarchar) itemID, '{ "companyName" : "'+replace(isnull(@companyName, ''), '"', '')+'", "num" : "'+cast(isnull(@num, 0) as nvarchar)+'", "date" : "'+isnull(@pdate, '')+'", "parentDocName" : "'+isnull(@pparentDocName, '')+'", "sum" : "'+cast(isnull(@psum, '') as nvarchar)+'", "customerPost" : "'+isnull(@customerPost, '')+'", "customerFIO" : "'+isnull(@customerFIO, '')+'", "docID": '+cast(@docID as nvarchar)+' }' parameters, 'generatedoc_uploadGD' spCallback, cast(@docID as nvarchar) docID
2. Creating a procedure for uploading the created document to the server
In it, we extract the parameters we need and call upload to Google Drive via an external action, and also specify spCallback to process the incoming FileID.
The url and docID parameters are extracted from parameters (they get there from the external generatedoc action).
ALTER PROCEDURE [dbo].[outer_generatedoc_uploadGD] @parameters ExtendedDictionaryParameter readonly, @data nvarchar(128) = '', @username nvarchar(128) = '' AS BEGIN -- SELECT 1 ReesultModel select 1 Result, '' Msg declare @path nvarchar(256) select @path = Value2 from @parameters where lower([key]) = 'url' declare @docID nvarchar(256) select @docID = Value2 from @parameters where lower([key]) = 'docid' declare @folderId nvarchar(128) select top 1 @folderId = docFolderGoogleID from fin_contragents where id in (select contragentID from rudenas2x.dbo.doc_documents where id = @docID ) declare @s nvarchar(256) = 'outer_generatedoc_uploadGD = ' +isnull(@path, '') +' '+ isnull(@folderId, '') exec as_print @str = @s if(isnull(@path, '')<>'' and isnull(@folderId, '') <>'') begin -- SELECT 2 Outer actions select 'gd' type, 'upload' action, doc_getDocName(cast(@docID as int)) filename, @path filepath, @folderId folderId, 'generatedoc_uploadGD_saveFileID' spCallback, @docID docID end
3. We implement processing for saving the file and calling export to PDF
ALTER PROCEDURE [dbo].[outer_generatedoc_uploadGD_saveFileID] parameters ExtendedDictionaryParameter readonly, @data nvarchar(128) = '', @username nvarchar(128) = '' AS BEGIN -- SELECT 1 ReesultModel select 1 Result, '' Msg declare @fileId nvarchar(256) select @fileId = Value2 from @parameters where lower([key]) = 'fileid' declare @docID nvarchar(256) select @docID = Value2 from @parameters where lower([key]) = 'docid' declare @s nvarchar(256)= 's='+ isnull(@fileId, '') if(isnull(@fileId, '')<>'') begin update doc_documents set gdfileId = @fileId where id = @docID end @declare @path nvarchar(128) = '/uploads/e1.pdf' -- SELECT 2 External export action -- select 'gd' type, 'export' action, @fileId fileId, 'pdf' exportType, @path path END
4. On the JS side, in the callback of the saveItem form, you can optionally process the created @path (must be passed to data.additionalData)
as.formcallbacks.[formCode]_saveItem = function(data){ console.log(data) // location.href= ... }
-