Maximize ROI with Cubewise
RO. Optimization matters.
Even before getting interested in Artificial Intelligence (AI), I have always enjoyed puzzles. French mathematical games (see trophy below left) for 30+ years. Moreover I managed to solve 50+ IBM Ponder This challenges.
In 2019, I met some IBM business partners in Vienna to explain the value of decision optimization.
IBM Planning Analytics / TM1 automates planning, budgeting, and forecasting.
IBM ILOG CPLEX Optimization Studio :
Rapid development and deployment of decision optimization models using mathematical and constraint programming.
Cubewise, enjoyed my presentation and even took some pictures during my presentation.
Later on, at their own customer events, it was my turn to take some pictures of them pitching CPLEX on top of PA.
I was very happy with that but that was only the beginning.
In 2020, they made me very happy. They asked me a puzzle (Not solve a puzzle this time, but write the challenge that will make other people crazy, not me!)
And not only for fun : the winner would get a real prize : a trip!
CUBE+WISE=MORE
Use each number between 0 and 9 only once, to replace the letters in the sentence.
The sum must be correct, you must use each number EXACTLY once. With the correct sum, there are many solutions. But which solution has the highest value for the letters R, O and I?
Target: Maximize the value of ROI. There is only 1 correct largest value for ROI. What number (like 123) corresponds to the letters ROI?
One can solve this challenge with a pencil but it takes some time.
Let me take the opportunity to explain how easy it is to solve this puzzle with IBM CPLEX.
Within IBM CPLEX you may rely on OPL and write
using CP;
...
dvar int CUBE;
dvar int WISE;
dvar int MORE;
dvar int ROI;
maximize ROI;
subject to {
CUBE+WISE==MORE;
ROI==100*R+10*O+I;
CUBE == 1000*C+100*U+10*B+1*E;
WISE == 1000*W+100*I+10*S+1*E;
MORE == 1000*M+100*O+10*R+1*E;
// all letters are different
allDifferent(append(C,U,B,E,W,I,S,M,O,R));
}
Which is very easy to read and gives the solution in less than 1 second.
You may do the same with Python.
CUBE=1000*C+100*U+10*B+E
WISE=1000*W+100*I+10*S+E
MORE=1000*M+100*O+10*R+E
ROI=100*R+10*O+I#constraints
mdl.add(CUBE+WISE==MORE)
mdl.add(mdl.all_diff(C,U,B,E,W,I,S,M,O,R))#objective
mdl.maximize(ROI)#solve
msol=mdl.solve()
You may also use a more generic model:
string maxobjective="ROI";
string equation="CUBE+WISE==MORE";
that will build the OPL model and solve this.
I used Constraint Programming solver within CPLEX. But Mathematical Programming works too both in OPL and Python.
Enumeration in OPL, Python or Javascript work fine too for this tiny challenge. For real business problems that could take years or even much more time. This approach cannot scale.
Thanks again Cubewise and congrats Cansu Agrali for winning this contest.
Let me quote Cubewise as why complete enumeration is not enough in real life:
Decision Optimization
“Considering we have a solid plan in place and we have an accurate vision of the future, there is only one thing left to do: execute it ! The reality is that we need to execute this plan in an environment that is full of constraints, conflicting targets, and thousands of options to consider. Decision Optimization focuses on what route is best to follow within the constraints we have, given the targets we set in a specific priority.
Today, CPLEX is the best performing solution to tackle these mathematical algorithm challenges. As a bonus, it integrates perfectly with TM1.”
No Optimization within AI is as bad as using only your reptile brain instead of your primate brain. Not wise when you want to get our of a maze.
