Designing for Damp Conditions
Designing for Damp Conditions
a reduction in lumber or plate design properties can help
ensure trusses perform as the building designer intends.
ANSI/TPI 1-2014 requires building designers to identify in construction documents any conditions that are expected to result in high wood moisture content, sustained high temperatures or environments that have the potential to cause truss plate corrosion (section 2.3.2.4(g)(6)). Each of these conditions requires a reduction in lumber or connector plate design values. In addition, these environments might require chemical treatment of the lumber or corrosion protection of the plates. Truss technicians who recognize the situations that create these conditions can implement appropriate design practices to mitigate potential serviceability issues and to ensure the trusses are designed to perform as intended by the building designer.
Design values for stress-graded dimensional lumber, published in the National Design Specification® for Wood Construction (NDS), apply only to wood with a maximum moisture content of 19 percent that is used in dry service conditions. Typical applications include enclosed buildings, properly ventilated roofs and covered structures where members are protected from the weather. However, when the moisture content of wood is expected to exceed 19 percent for an extended period of time while in service, allowable design values must be reduced by the appropriate wet service factors.
The wet service factors for truss design vary by property. For example, there is no reduction for tension parallel-to-grain (Ft), but a 33 percent reduction is required for compression perpendicular-to-grain (Fc˔). Additionally, the lateral resistance (or grip) value (VLR) for metal connector plates is reduced by 20 percent.
The same 20 percent reduction of plate grip applies to trusses that are fabricated with green or wet lumber, where the moisture content is greater than 19 percent. However, no reduction is required when those green or unseasoned lumber trusses are used in an application that results in the wood elements drying to and remaining below a 19 percent moisture content.
Lumber moisture content is expected to exceed 19 percent when the wood is exposed to an average air humidity of 85 percent or more for an extended period of time or when the wood has direct exposure to rain and other moisture sources. For example, wet service scenarios might include:
- Floor trusses over a crawl space and within 18 inches of exposed ground.
- Trusses supporting an outdoor balcony with a moisture-permeable floor covering like concrete or masonry and without an impervious moisture barrier.
- Trusses over an indoor swimming pool where the plenum or attic space is insufficiently ventilated and conditioned.
- Open-air sheds that experience repeated wetting and drying due to rain.
- Agricultural buildings housing livestock where slatted floors hold manure slurry.
A sustained high moisture level not only has an adverse effect on wood strength properties and plate grip, but it also makes wood more susceptible to wood-destroying fungi and decay. Accordingly, if trusses are to be placed in high moisture applications, truss designers should select a wood species that is naturally resistant to decay or preservative-treated lumber.
Of course, preservative treatment options can also affect lumber and connector plate design properties—but that’s a topic for a future article!