14/07/2016
Nick Anderson and Hamish Chamberlayne, co-managers of Henderson’s global equity sustainable investment strategy, discuss the rise of impact investing and why it could be a fundamental force for positive change.
New buzz, old idea
Impact investing has become quite the buzz term in the last few years, generating significant debate over what it is, is not, and should be. The concept is actually much, much older, if we recognise its roots in the sin exclusions of 18th Century American society*. The Rockefeller Foundation coined the modern term as we know it (in 2007), in order to help rally disparate social investing forces under a more cohesive banner, paving the way for the foundation of the Global Impact Investing Network (GIIN) in 2009. The GIIN itself considers impact investments to be those “made into companies, organisations, and funds with the intention to generate social and environmental impact alongside a financial return”.
Although there are those who would argue for a narrower definition – preferring to focus on the ‘locality’ of operations, and on the ‘social’ needs of the poor and marginalised – we favour the GIIN’s broader one, which is outwardly global and inclusive: after all, the world’s most complex problems are a shared burden requiring a cohesive response. Trends such as climate change, resource constraints, ageing demographics, and population growth are having tremendous global transformational effects on human life and the wider biosphere. The action required to mitigate them simply cannot be accomplished at scale without help from the private sector. Traditional forms of philanthropy and government-led development programmes are subject to the mercy of their sponsors/donors, and potentially unsustainable given the enormity of the problems faced.Growth spurt
Despite the challenges, there have been some encouraging developments. The GIIN estimates the investment market for impact capital, currently sized at c.US$77 billion, could grow over the next ten years to $2 trillion, or 1% of global invested assets, helped by growing awareness, widening accessibility, and legislative changes. In major developed economies the largest proportion of financial wealth held by individuals is typically within employee savings and pensions plans. Herein lies a tremendous opportunity for ordinary people to catalyse social and environmental change. This is becoming possible as governments consider broadening the definition of qualifying impact investments, launch new vehicles, (eg, European Long-Term Investment Funds), and better incentivise participation, for example through specific tax breaks.
Impact investing is no longer the preserve of wealthy individuals, philanthropic trusts, or institutional schemes with access to the private equity and debt vehicles that have dominated approaches historically. More products are now being launched for the mainstream community that offer, for example, portfolios of stocks and shares in publicly-traded companies positively selected for their social and/or environmental credentials. We would argue that these should be considered on a case-by-case basis under the umbrella of impact investments.
The indications thus far are that supply of socially and environmentally-orientated funds in the retail space is being met by increasing demand: research by pan-European think-tank Eurosif confirms that appetite for themed sustainability funds across Europe is building, with this part of the market growing at double-digit rates since 2011. Other studies have also suggested that that the Global Financial Crisis catalysed interest in corporate responsibility, and towards ways of investing more closely aligned with personal values, notably among Millennials.
Returns, not charity
There are, however, barriers to overcome in terms of the public perception of impact investing, concerns that have also traditionally dampened interest in wider sustainable and responsible investment (SRI) strategies. The most significant worries cited are performance and risk. There is often a misconception that financial returns have to be sacrificed in order to accomplish non-financial goals. Different impact investing strategies are designed to target a range of returns. Analysis conducted by investment research firm MSCI in the run-up to launching its All Countries Sustainable Impact Index – which selects companies based on rigorous sustainability and ESG criteria – showed the filtered index had outperformed its unfiltered All Countries Index on an annualised basis over a period of five years**.
This and other substantial research supports the view that companies involved in the building of future industries, and that are developing sustainable business practices and building robust and ethical supply chains, not only have the potential to consistently grow earnings, but also limit numerous regulatory and operational risks. This is one of the reasons that we use both positive and negative (exclusion) screening criteria to construct our portfolios. We believe investing using positive criteria/thematic selection is best carried out in tandem with checks that police against investment in harmful products and business practices.
Measuring outcomes
Intentionality, return expectations, and measurability are the cornerstones of impact investing, meaning that as interest grows in this market, there will be a greater focus on accurately assessing outcomes. Measuring impact within investment funds poses difficulties from quantitative and qualitative perspectives, but data collection and methodologies are improving. To help standardise measuring and reporting, the GIIN created Impact Reporting and Investing Standards (IRIS), a catalogue of generally accepted performance metrics gauging corporates’ social, environmental, and financial successes.
MSCI has recently developed a new framework to support aligning investments with the United Nations’ 17 Sustainable Development goals; this will become a major area of focus for impact investing as member states use the goals to frame their agendas and political policies over the next 15 years. Carbon footprint reporting has also become more sophisticated, allowing portfolio managers to manage their carbon liabilities. Henderson has been working with Trucost since 2005 to carbon audit its SRI portfolios, something that has been subsequently rolled out to all Henderson equity strategies to allow them to track their carbon exposures. Our global equity SRI fund is one of the lowest carbon global equity portfolios available in the investment funds market.
Impact investing will continue to generate debate about what types of investment should and should not be included under its broad mantel. One thing is certain, social and environmental-focused strategies have rightfully earned their place in the market and are making people question traditional approaches: doing good has never felt so rewarding.
*For example, Puritan society in Britain and North America sought to prohibit vices such as drunkenness, and gambling. Later, the Methodist church was one of the first religious organisations to oppose investments in businesses producing alcohol, tobacco products, and/or promoting gambling.
**MSCI ESG Research: Sustainable Impact through Public Markets Study, 2015. Historical and simulated data from November 2010 to November 2015. Please note that past performance is not a guide to future performance. ESG = Environmental, social and corporate governance..