Ever since it first came to market in 1993, the anticonvulsant drug Neurontin has consistently been one of Pfizer's top earners, generating considerable sales and driving strong growth for the New York-based company. With this drug set to lose patent protection Pfizer is gearing up to launch its replacement. Datamonitor investigates whether pregabalin will allow Pfizer to maintain its market share. In the brief Pregabalin: Follow-On Strategy a Winner for Pfizer Datamonitor analyzes why Pfizer s developing pregabalin, through analysis of the blockbuster Neurontin. It predicts the outlook of pregabalin in three main markets it is expected to enter; namely epilepsy, anxiety, and neuropathic pain, by analyzing clinical trial data and competitive activity. The pros and cons of off-label prescriptions are discussed, and forecasts are provided for Neurontin and pregabalin to 2010. Neurontin, whose active ingredient is gabapentin, is approved in more than fifty countries worldwide for a variety of indications, including the adjunctive treatment of epilepsy and a range of neuropathic pain conditions. Since its launch, the treatment has rapidly grown to blockbuster status generating sales of over $2 billion in 2002 alone. But the imminent loss of patent protection means that this cash cow will soon be subject to imminent challenges from cheap copycat versions from generic manufacturers. Delaying tactics In order to stave off this threat and so maintain and grow its share of the anticonvulsant market, Pfizer must ensure that a follow-on pregabalin compound is launched before Neurontin loses its patent. Such a strategy would be typical of Pfizer, which has maintained leadership in other CNS markets, such as depression and pain, through the successful launch of follow-on products. Neurontin's patent originally expired in 2001, although, just prior to this, Pfizer produced a production patent that granted the drug protection until 2014. However, this patent has since been challenged by several generic manufacturers in the courts, with accusations that Pfizer was illegally seeking to perpetuate their monopoly on the drug. In response, Pfizer has sued the generic manufacturers to prevent them from manufacturing generic versions of Neurontin. Pfizer has therefore secured itself additional time to effectively prepare pregabalin for launch. The company is doubtless aware that as soon as Neurontin finally loses patent protection sales will drop dramatically. The FDA has already granted Alpharma market exclusivity for generic gabapentin. The exclusivity currently applies to 100mg, 300mg and 400mg capsules, but the company anticipates that the FDA will extend it to include 600mg and 800mg gabapentin tablets as well. Alpharma, however, expected to wait for a court ruling on the validity of Pfizer's production patent before entering the market. Pregabalin groundwork Like Neurontin, its planned replacement is a 3-substituted analog of gamma-amino butyric acid (GABA). It is thought the two compounds share similar mechanisms of action, binding to the calcium channels, modulating calcium influx, and resulting in analgesic, anxiolytic, and anticonvulsant activity. Studies have shown two key differences between the drugs: Pregabalin provides equivalent efficacy at lower doses, and because of this, pregabalin is unlikely to be associated with dose-related adverse events, such as fatigue. Pfizer has already begun laying the groundwork for pregabalin's product lifecycle by using Neurontin to establish its position in a number of key markets. Pfizer's strategy is to establish Neurontin in markets that pregabalin will be launched into, so the acceptance by physicians of the new compound is high. This has been approached either through an actual indication (e.g. neuropathic pain) or through the publication of clinical trial data to encourage off-label use. Datamonitor expects off-label prescriptions of pregabalin to be a profitable source of sales, as has been the case with Neurontin. However, this is a risky strategy and Pfizer must consider several key issues surrounding off-label usage to avoid negative publicity. Off-label use refers to the use of an approved drug for any purpose other than what is described in the drug's labeling, and over 70% of Neurontin sales come from off-label prescriptions. In essence, the more versatile a drug is, the greater its revenue generating potential, and Pfizer expects pregabalin will be used as a safer alternative to Neurontin. Another blockbuster? However, to avoid lawsuits, loss of reputation and bad publicity, Datamonitor recommends that Pfizer drives off-label pregabalin usage through the presentation of clinical information in respected peer-reviewed medical journals and independent clinical studies. Datamonitor believes pregabalin will provide Pfizer with yet another blockbuster product. Sales are expected to cannibalize Neurontin following launch in 2003, as Pfizer minimizes generic erosion by convincing physicians to switch therapies. Datamonitor forecasts pregabalin to achieve blockbuster sales by 2010. Due to the fact it offers a superior clinical profile to its predecessor, physicians are expected to switch from full priced Neurontin to pregabalin. While Neurontin is only indicated as an adjunctive therapy in the treatment of partial seizures in epilepsy, wider approved treatment indications will ensure a greater patient potential for pregabalin and allow Pfizer to market the new drug directly to physicians and patients for these indications, rather than depend on off-label use..