Jump Trading makes the jump to VAST Data for cutting-edge machine-learning models
Chicago-headquartered trading firm Jump Trading has always sought an edge. Jump is a research-based organization committed to using the latest technology to innovate and push through scientific boundaries — and it applies this to financial markets all over the globe. Jump has over 20 offices in the United States, Europe and Asia. "Our success is reliant upon our ability to make ever-growing amounts of data available, quickly, for cutting-edge research pipelines," explained Alex Davies, technology leader at Jump Trading responsible for both Jump's low latency and High Performance Computing infrastructure.
"Every day the global financial markets create incredible amounts of new data that we need to consume, and our success is reliant upon our ability to make this data available to researchers — and available quickly," Davies said. Davies knows better than most that in the competitive world of algorithmic trading, small increases in model accuracy can mean the difference between windfall profits and catastrophic losses. "The most productive quants have the competitive advantage, and a huge amount of that productivity relies on fast access to massive amounts of data," said Davies.
Everyone knows that to make money, you have to spend money. But justifying a significant outlay of the type needed to create a competitive advantage using traditional means can be difficult to do. Flash storage is expensive at scale, and even costlier at high performance levels. The most efficient flash storage of the type required by Jump is extremely expensive.
Or rather, it used to be. "We focus on customers that find themselves at the intersection of both performance and scalability," said Jeff Denworth, co-founder of VAST, which democratizes fast access to data by combining industry-leading techniques to simplify and speed up storage and access to data in real time, at lightning speed. VAST does this by consolidating multiple data storage tiers. The VAST Data Universal Storage makes it possible to store all data on a single tier of fast, scalable and affordable flash, so that customers don't have to deal with complex data movement workflows or high application wait times as data moves between the various tiers of storage.
VAST is growing fast and innovating, and it doesn't seem to be stopping"
"The mission of VAST is to be an extinction-level event for the hard drive," said Denworth. VAST recognized that solving the cost problem and adding elements of system scalability unlocked the market and offered enormous returns for clients. The company was founded in 2016 with that premise; by 2018, it sold its first product. Within three months, VAST was well on its way: It sold more than any storage company ever had in its first year of operation. "We've not only changed the paradigm in terms of how people think about managing their data, and how people get fast access to all of their data, but also by focusing on scalability," said Denworth.
It was a perfect fit for Jump. VAST recognized earlier than most that the dual rise of AI and machine learning would upend the data infrastructure market. Customers are realizing that they need fast access to the largest amounts of data in their data center in order to make their models more accurate and effective (by exposing them to the largest sample data sets). Jump selected VAST because it had cracked the code to obtain great capacity and performance.
VAST can crack that code in part because of the tech hardware it runs on: Its own Universal Storage architecture is powered by Intel Optane SSDs and Intel QLC 3D NAND Technology. Intel Optane SSDs provide endurance and high performance for writes, and Intel QLC 3D NAND SSDs are affordable, high-capacity NAND flash drives that deliver great read performance. VAST has also found a way to achieve 20 times the benchmarked longevity of Intel QLC 3D NAND SSDs, meaning customers can deploy super-fast, high-performance storage that lasts for a decade, compared to the industry standard of three to five years. "We use these technologies to overcome a number of shortcomings that you would traditionally find in storage systems," said Denworth — and VAST passes that on to its customers.
When Jump migrated the backbone of its trading archive infrastructure over to VAST, it quickly witnessed the positive impact. "VAST makes a difference on how quickly Jump can access what they need when they need it," said Davies. Denworth added: "We were factors less expensive than any other all-flash system they could otherwise purchase, which allows Jump to put more data on a platform than any other system for the same investment dollar."
By building out capacity and speeding up compute times for that data, Jump was able to feed more information into its algorithms to enable those algorithms to make more informed trading decisions. "The concept has completely changed customers' perceptions and market appetite for high-performance infrastructures," said Denworth, who claimed that the VAST on-premises all-flash storage investment is around one-sixtieth of the cost of deploying in the cloud.
"VAST has changed the economics of flash storage," said Davies. "It's making flash affordable at large scale — and less expensive for all kinds of data and data sets." The market has taken notice: Last quarter, VAST's average contract value was $2 million. In May, the company took on $83 million in series D funding, valuing VAST at $3.7 billion — three times its value in April 2020. "When investors hear that we built a business that, in our second year of operation, hit a $150 million run rate and achieved cashflow positivity, people love it," said Denworth.
"VAST is growing fast and innovating, and it doesn't seem to be stopping," said Davies. "We're reassured to be partnered with a company that is well-capitalized and growing." Trading firms like Jump are far from the sole use case for VAST Universal Storage: Multiple industries that require rifling through vast quantities of data at great speed are starting to adopt VAST technology to power their businesses, including health care, research institutions, federal government, manufacturing, and media and entertainment.
"We're still in the first inning of the proliferation of AI and machine learning across the enterprise, but no doubt that it is the killer use case for distributed storage," said Denworth. "It is being infused into every application and our job is to modernize the data infrastructure so that it is accessible and can work with AI at any scale."