A series of murders involving British nationals in Kenya in recent weeks has raised concerns over whether conditions in the east African country are deteriorating again. The British Foreign Office has warned Britons to be mindful of increased risks in Kenya.
These most recent slayings resulted from botched robberies and, in two instances, the victims were former members of the British military – Lt. Col. David Parkinson and Col. Edward Loden. Kenya is a popular destination for British travelers, attracting more than 200,000 visitors each year. Crime rates, however, are very high.
A memorial for Parkinson this month brought renewed attention to these crimes, as he was a popular and well-liked member of the expatriate community in Northern Kenya. Parkinson worked on nature reserves, including the one where Prince William proposed to Kate Middleton, and was active in supporting refugees displaced during the turmoil of the disputed 2007 elections, which led to more than 1,000 deaths. Two weeks ago, he was hacked to death with machetes at his home outside Nairobi. Parkinson’s widow has called for the gang responsible for her husband’s murder to be brought to justice. In addition to his computer and cellphone, the attackers made off with only the few dollars that Parkinson had on him at the time.
Shortly after Parkinson’s death, Loden, who was visiting his son in Kenya, was shot by a group of burglars who forced their way into the family compound in Nairobi and made away with jewelry and money. His son Jamie, who also served in the same British army regiment as his father and Parkinson, works for Barclays Bank.
Kenya wrestles with tensions stemming from deep internal divisions. Notably, the Kenyan government this week withdrew from the International Criminal Court in protest of charges being brought against both President Uhuru Kenyatta and Deputy President William Ruto, involving crimes against humanity and other offenses related to inter-tribal violence following the 2007 election. Opponents in 2007, Kenyatta and Ruto were successful allies in this year’s election, although Kenyatta only won re-election by a very slim margin.
As is often the case with contemporary Africa, rhetoric and propaganda share center stage with serious questions over accountability and commitment to democratic values. Allegations of racism and neocolonialism are being bandied about by supporters of Kenyatta and Ruto, since the ICC’s focus to date has been primarily on African leaders. Notably, though, when President Barack Obama toured Africa earlier this year, he made a point of avoiding the country of his father’s birth, causing great embarrassment to Kenya and to President Kenyatta. Obama’s snub was meant to convey a message about the seriousness of the allegations from the ICC and the failure of the government in Nairobi to adequately respond to the charges.
Africa faces massive challenges in the 21st century. Many of these stem from the colonial period in the 19th century, multiplied by the copious errors and omissions of the 20th century. However, there is still ample room to criticize a series of modern leaders who have failed to take adequate steps to institutionalize democracy, rule of law and civil society.
It would be a grave mistake, though, to write off Africa. Despite the obstacles they currently face, these countries, including Kenya, still have vast potential. But, in the face of American indifference, China is taking the opportunity to invest both time and money to strengthen its relationships on the continent. The difficult question for the United States and Europe is whether, given the strong historical ties that the West has to Africa, they are willing to make Africa a priority in the near term, rather than just a vague charitable endeavor in the medium-to-long term.
The connection that Britain still has to Kenya is tangible and real. With sufficient attention and priority, these historical and cultural ties could be harnessed by Kenyans to assist them in overcoming their various challenges. The recent killings, however, risk driving these countries further apart.
For a cautionary tale of what happens to an African country that categorically rejects the international community and recedes into its own insular cocoon, one needs look no further than Zimbabwe. Contrary to the thumping speeches of Robert Mugabe, targeting white settlers for escalating violence has not proven to be a sure-fire recipe for Zimbabwe’s fast-track development.
Kenya’s great potential should not be further postponed by allowing it to descend again into a downward spiral of violence. All Kenyans deserve better..