- Authors:
-
- Abstract:
- Pharmaceutical ingredients have traditionally been produced in batches using multipurpose stirred vessels. Reactions and separations have typically been tailored to fit these units, facing multiple limitations when transferring synthetic routes from the laboratory to industrial scale. Scaling up thus resulted in many cases in low reaction yields and separation efficiencies. These limitations were however compensated by a relatively fast process implementation. For the pharmaceutical industry this meant that new drug products could be exclusively marketed for a longer time period, resulting in higher benefits than those that could be obtained with a highly optimized process requiring extra development time. Being the first to commercialize a product also meant a fundamental marketing advantage, since healthcare professionals commonly related pharmaceutical products to the original trademark. Furthermore, once a pharmaceutical product was approved, changes to the original production process could only be achieved at the expense of revalidating the whole process in a worldwide market, which typically prevented pharmaceutical companies from optimizing already existing manufacturing processes. Today, however, the pharmaceutical industry is facing a globalized market where national health institutions increasingly favor the prescription of low‐cost generics, and it is more and more expensive to develop new pharmaceutical ingredients with the potential to become, for a few years, blockbusters. Fierce competition has therefore resulted in a need to reduce manufacturing costs and optimize the efficiency of production processes. In addition, ethical reasons and ever stricter legislations demand the development of sustainable processes with the lowest possible environmental footprint. Continuous pharmaceutical manufacturing has been proposed as a way to facilitate process development and scale up, resulting in higher yields, improved quality, lower risks and reduced environmental impacts. Regulatory agencies, such as the FDA, have encouraged the transition towards novel technologies through increased process understanding. Developing a process within a more flexible design space based on sound engineering judgment potentially allows process optimization once the product has already been approved. Micro‐ and mini‐chemical systems have been envisaged as the optimal scale for pharmaceutical production, due to improved heat and mass transfer allowing safer operation in a larger design space. Scaling up to high throughputs could then be performed by replicating small‐scale units as required. However, significant uncertainties arise. For example, when should continuous processes be selected? Where are the highest benefits found? How can a continuous process be designed and implemented? Are continuous processes compatible with slow reactions? Do they allow problem free processing of solid particles? What is the cost needed to implement a continuous process? This PhD thesis tries to answer some of those questions through the development of a systematic framework that takes advantage of continuous processing technologies and process systems engineering for the efficient design of continuous pharmaceutical processes. The framework consists of a step‐by‐step procedure that guides the user from drug discovery and the initial process development steps towards process implementation. Guidelines are suggested for the selection of the most suitable operating mode. Conceptual continuous processes can then be compared against traditional batch‐wise processes in order to evaluate potential cost savings and/or lower environmental footprints. The design framework has been applied to a process originally developed by H. Lundbeck A/S to produce zuclopenthixol, an active pharmaceutical ingredient. The synthetic process includes four reaction steps (alkylation by a Grignard reaction, hydrolysis of the alkoxide product, dehydration and hydroamination) with very different kinetics and thermodynamics, and several separation and solvent exchange steps. The implementation of continuous processes provided improved product quality without the need of some of the product isolation and purification steps, resulting in a significant simplification of the process. The process mass intensity (kg of raw materials used per kg of product obtained) could then be reduced to at least half the original value. In this thesis, three of the unit operations included in the zuclopenthixol process were studied in detail. Specifically, the continuous alkylation reaction was achieved using a filter reactor coupled with a side‐entry tubular reactor, using real‐time in‐line near‐infrared (NIR) spectroscopy for monitoring the reaction and ensuring the right product quality. A subsequent hydrolysis of the alkoxide product was performed in continuous mode in a tubular reactor with segmented flow. The product of the hydrolysis reaction was fed to a hydrophobic membrane separator where the organic and aqueous phases were split. The organic phase was then dehydrated in continuous mode in a pressurized tubular reactor where the reaction rate of an otherwise slow reaction could be optimized by increasing the temperature above the normal boiling point of the solvent. These three unit operations could potentially be employed in similar reaction and separation steps, thus constituting ‘continuous‐flow building blocks’ for the design of novel continuous pharmaceutical processes.
- Type:
- Thesis PhD
- Language:
- Main Research Area:
- Science/technology
- Publication Status:
- Published
- Review type:
- Undetermined
- Supervisor:
- Kiil, Søren, Gani, Rafiqul, Gernaey, Krist
- Publisher:
- Technical University of Denmark, Department of Chemical Engineering, 2011
- Submission year:
- 2012
- Scientific Level:
- Scientific
- ID:
- 2185752541