When John O’Keefe, May-Britt Moser and Edvard Moser were awarded the Nobel Prize in Physiology or Medicine this week, they continued a trend that has become a hallmark of the Prize for many decades – multiple winners. Since the end of World War II, the Prize has gone to two or more winners far more often than to a single person. Clearly, not all Nobel Prize co-recipients were close collaborators, and many were fierce competitors. But, in rare cases has the work of one winner not had a profound influence on the work of the others – working at distance but driving each other to new heights in search of solutions.
As a society we tend to associate genius with individuals, but rarely is this actually true. Creativity is iterative; a construct-and-destruct cycle that relies on feedback, pushback and challenge. History and research teach that the most productive forms of creativity occur in pairs; two individuals often remarkably different but with shared interests and inter-dependencies that play off each other to solve a shared problem. (With this in mind, one only imagines the dinner table conversations that take place between May-Britt and Edvard Moser, or any of the other three married co-winners to share a Nobel.)
Because we romanticize the lone genius and place too much emphasis on the importance of being in close proximity, history often overlooks the creative interplay between dynamic pairs. We see Einstein and not his muse Michele Besso. We read C.S. Lewis and J.R.R. Tolkien in isolation, not appreciating the impact that each close friend had on the other.
Many dynamic pairs remain evident and durably impactful for years – Watson and Crick, Lennon and McCartney, or Langer and McGuire are all excellent examples of remarkable individuals that have achieved extraordinary outcomes not because of their exceptional individual talents, but because of their desire to aspire beyond their individual potential.
Most recently, the collaboration between Drs. Emmanuelle Charpentier and Jennifer Doudna has led to discovering new bacterial immunity systems and then to genome editing – discoveries that are poised to help drive remarkable biotechnology advances and new medicines. For this work the pair was awarded the prestigious 2014 Dr. Paul Janssen Award.
In the world of start-ups and innovation, an increasing level of attention is being paid to the role of co-founders, replacing the outdated picture of a single, driven entrepreneur that has captivated us for so long. Start-ups that are built by highly inter-disciplinary co-founders invariably have aspirations that are much greater than single-founder enterprises.
Sam Altman (President, Y Combinator) has pulled together a new course at Stanford this fall called CS183B – How to Start a Start-Up. It boasts a terrific set of expert guest lectures, including Peter Thiel, Marc Andreessen and Marissa Mayer among others, and many of the lectures center on the theme of collaboration and co-founding – picking huge problems that you and your co-founder are desperate to solve, working off and against each other in a creative tension that drives forward product improvement, using that energy to simulate what you and your customers expect from your product… ultimately, starting your enterprise with iteration, feedback and robust destructive-then-constructive dialogue that can hold the key to building durable winners.
We all aspire to be individually accomplished, recognized as “the person” who pulled off great feats. According to Altman the operative equation for a start-up is more like success = idea x team x execution x luck. In reality, execution is likely 10 times more impactful than the original idea, while the value contributed by luck can range from 0 (tragic) to 10,000 (remarkable). In other words, the constant and controllable variable in the equation is the team and the dynamic exchanges that are fostered among them.
Humans are socially dependent beings. From birth we learn together, at first from the simplest forms of emulation to eventually more competitively driven group learning environments. Even the most introverted among us can be found verbosely conversing with ourselves, as we strive to provide the counterpoints needed to be creative, our inner voice becoming the substitute for a physical thought partner. Many intensely driven and accomplished individuals only reach their full potential after they open up to the myriad voices outside of themselves, which can give new shape to our perspectives and help that turn a personal quest into something with deep societal impact.
Next post we will explore the impact of habits on innovation.