
Children have the right to a joyful childhood. Every child has the right to grow up in a safe and nurturing environment with protection and guidance from their guardians. Whether in the cities or in villages, at home or in schools, a child is always a child and deserves a childhood free from exploitation and abuse.
Yet millions of children are being robbed of their childhoods every day. With an officially estimated 12.6 million children engaged in hazardous occupations (2001 Census), India has the largest number of child labourers under the age of 14 (indigenous cigarette in which tobacco is rolled in a tendu leaf).
In addition, nearly 85 per cent of child labourers in India are hard-to-reach, invisible and excluded, as they work largely in the unorganised sector, both rural and urban, within the family or in household-based units, which are generally out of the purview of labour laws. (Click here to know more about child labour in India: ).
Over the years the Government of India (GoI) has multiplied its efforts to address the needs and rights of exploited children. The largest and most structured intervention in the area of child labour in India is the National Child Labour Projects (NCLP). The programme, addressing children rescued from hazardous labour and centrally managed by the Ministry of Labour (MoL) includes the establishment of special schools to provide children with the skills they need to be mainstreamed into the formal system, vocational training, supplementary nutrition, health services etc.
In January 2005, the National Child labour Projects scheme has been expanded to 250 districts in 21 different Indian states, covering 42 per cent of all districts of the country (2001 Census).
UNICEF uses the Article 32 of the Convention on Rights of the Child (CRC) ,which articulates child labour as “any work that is likely to be hazardous or to interfere with the child’s education, or to be harmful to the child’s health or physical, spiritual, moral or social development”, as the foundation of its work in India.
In line with this framework, UNICEF India, in partnership with central and state governments, as well as with NGOs and other key groups, is implementing initiatives aimed to build a protective environment in which children can live and develop according to their fundamental rights. Translated into action, this approach led to a programme whose main scope is the progressive elimination of ALL forms of child labour to comply with Article 32 of the CRC ratified by India in December, 1992.
UNICEF hopes the World Day Against Child Labour (WDACL), which is observed worldwide on or around 12 June each year, serves as a catalyst for the growing worldwide movement against child labour.
Restoring Childhoods
1. Promoting children basic right to education. Core to UNICEF programme, is the emphasis on children’s entitlement, access and retention in education as major strategy to eliminate, but most importantly to prevent child labour. Initiatives include mass enrolment campaigns, support to transitional education programmes (bridge schools), community based sensitisation programmes, education quality package for formal education, as well as initiatives aimed to facilitate and strengthen strategic convergence among key institutional stakeholders.
2. Capacity building of marginalised communities towards the elimination of child labour and towards the protection/promotion of child rights. In order to address the vicious circle of poverty as a major factor surrounding child labour, as well as based on a vision of women as key catalysts for change, UNICEF India is supporting the establishment of women self help groups (SHGs) in various project areas of the country. Other initiatives to empower communities towards the protection and promotion of children rights include village planning exercises, the establishing of community level anti-child labour watching committees, as well as the regular sensitisation and support to local systems such as the Panchayati Raj (village council) institutions.
3. Advocacy and social mobilisation against child labour Addressing existing attitudes towards child labour and facilitate people’s behavioural change towards a more protective environment for children are core components of the present GoI-UNICEF joint child labour intervention. This is addressed in the field through community-centered social mobilisation initiatives, implemented in collaboration with local authorities, non-government organizations (NGOs), community-based organizations (CBOs) and by a number of local motivators operating at village level. Building on field level experiences, at central level UNICEF is also developing a National Communication strategy against child labour.
Carlotta Barcaro contributed to this article.
Español Français
View video
Roll Call
Printer friendly