WHY
THIS APPROACH?
Many patients
have spent considerable time, effort, and money on conventional allopathic
psychiatry and other mental health treatments only to be disappointed with the
results. Many times this occurs because the philosophy of the problem and thus
the treatment is not correct. I am painfully aware that most psychiatrists
spend precious little time with each patient, depend heavily on major drug
company office representatives for their information on medications and
treatments, and do precious little outside reading of the scientific literature
on their own. Thus patients most often are placed far too quickly in a
diagnostic niche with very little appreciation of the complexity of their
difficulties and are often given those medications which fit the criteria of
drug company concepts of treatment. This amounts to a “recipe book” approach to
assessment and treatment. Occasionally it works, often it does not, and rarely
in my opinion are fundamental health issues adequately or comprehensively
assessed. To me this is a set up for
probable failure.
WHY DOES THE CURRENT SYSTEM OFTEN NOT WORK?
Most physicians are to be admired for the scope and depth of their medical training. But the system is “stacked against” both them and their patients. Increasing practice costs, decreased reimbursement (i.e. managed care), increased paperwork, federal regulatory demands, and the need to practice “defensive medicine” to avoid potential lawsuits make the time they can spend with patients less than desirable. This sets up an “evidenced based” approach which tends to influence physicians to practice in ways similar to other physicians. This can standardize care, but also tends to greatly reduce innovation and creativity. Even though they have the scientific background to address complex issues, these pressures rarely allow them to do so. Add to this a horde of drug company reps who present them with the “proper protocols” on how to prescribe and treat. This is done through the approval of new drugs by the FDA whose standard for efficacy to approve these drugs is a little better than placebo. To many who study these issues, this is a setup for failure and sometimes even outright disaster. The point is that complex problems often need a lot of careful consideration, time, and often “outside the box “thinking to find meaningful solutions. If one has a difficulty that has complex symptoms and complex causes, a simple, prescriptive approach often does not work. A good example of this is Fibromyalgia Disorder. Jacob Teitelbaum, M.D., noted expert on this disorder, states that the average patient sees nine physicians before they get a proper diagnosis and appropriate treatment. Why is this? It is because Fibromyalgia is a very complex, multi-system, neuroendocrine disorder that will not be understood or treated well by a simplistic approach. This leads to the all-too-common experience of patients who have complex problems that end up feeling patronized, misunderstood, not listened to, and not taken seriously. This causes feelings of frustration, anger, and hopelessness. It is not that they can’t be helped, it is more often they fail to get it because the approach is simply not right for their needs.
THERE IS A
BETTER APPROACH
Allow me to briefly discuss one aspect of my conceptual approach to illustrate how I assess and treat these issues. Every physician and nurse who has ever graduated from their medical training has studied the stress hormones adrenalin and cortisol. Virtually all would agree chronic, long term stress is destructive to health and causes real, physiological changes. We know there are two adrenalin receptor systems in the body and that over-stimulation of these leads to specific physiological symptoms. We also know scientifically how cortisol, one of the major stress hormones, should function in a balanced, normal system and what its effects are on the body, brain, and mind when it is too high or too low compared to the normal diurnal curve it should follow. Even though these things are clearly known scientifically, how many physicians regularly assess this when they suspect a stress disorder? How often do they order saliva cortisol testing, consider how the adrenalin receptor systems may be functioning and offer specific corrective therapies for these issues? I personally know very few who look at these dynamics, but instead people are commonly put on SSRI antidepressants or benzodiazapines or other common psychotropic medications which may not in any way address the specific systems which cause the symptoms. One cannot adequately treat a person with chronic insomnia with Ambien or another hypnotic medications if, for instance, their night time cortisol level is 300-500 % above what it should be. This person needs a specific strategy to address cortisol i.e. adaptogenic supplements, phosphatidylserine, etc. to specifically address highly elevated cortisol levels. This illustrates one of the many, many examples of the common failures in standard allopathic treatment. If one does not accurately and correctly assess the cause, one cannot provide an accurate and effective treatment. I prefer a system by system approach to assess the most likely cause of symptoms. One cannot take a generic, ” flow chart” approach to assessment and hope to understand what truly causes the dysfunction. Only this type of comprehensive approach can provide a targeted protocol to accurately address symptoms.