When the COVID-19 pandemic started spreading throughout the US in early 2020, Jessica Daly, consumer health librarian at hospital network Orlando (Fla.) Health, knew it was time for her—and other information specialists in the medical field—to step up.
, as well as other consumer health librarians across the country, began offering free webinars in hopes of educating the public about the virus—and perhaps saving lives in the process. Topics ranged from establishing and maintaining basic cleanliness routines to more specific concerns, such as combating fake news about the pandemic.
Webinars proved to be an ideal method for reaching patients who had health questions or were afraid to travel to their physician’s office, Daly says.
“A lot of families reached out to me saying, ‘How can I keep us safe? What can I do?’ Having a trained medical librarian at their disposal free of charge was and continues to be a valuable resource for so many during this most difficult time,” Daly says. Her first COVID-19 webinar, Germ Prevention: Protecting Your Family, was presented in June 2020 on Orlando Health’s website in response to community queries like these.
In that webinar, Daly gave tips on home and personal hygiene, from proper handwashing techniques to the best cleaners for sanitizing household objects. Some of the information may have seemed basic, she says, but it was important to reiterate—especially since certain cleaning products or methods may be new to some people.
“You may have read some really scary things [that] people did because they were just so afraid,” Daly says. “A lot of people think they can mix cleaners, especially with bleach. But you never mix bleach and ammonia. A lot of people do not know that.” (Combining bleach and ammonia produces toxic, potentially fatal gases.)
Those who don’t understand their options for accessing health care will be left behind.
Daly also hosted a webinar on things to consider before leaving the house during the pandemic, with advice on wearing proper face coverings, maintaining social distance, and getting tested after coming into contact with an infected person. The webinar’s goal was to inform and also to provide peace of mind for viewers.
“I never wanted people to be afraid to go out,” Daly says. “If they had to, I wanted them to feel confident when they did.”
Correcting misinformation
The COVID-19 pandemic has also prompted an increase in fake news, especially surrounding the virus’s origins and transmission. That has spurred some librarians to use webinars as a means of countering misinformation.
Antonio P. DeRosa, oncology consumer health librarian at Weill Cornell Medicine Sandra and Edward Meyer Cancer Center in New York City, produced a webinar last May titled Fighting the “Infodemic” of Misinformation on COVID- 19. Webinars are nothing new for DeRosa, who typically focuses on oncology, but the World Health Organization’s decision in February 2020 to call the phenomenon of rampant misinformation an “infodemic” inspired him to highlight the topic, he says.
DeRosa says questions to his office have skyrocketed since the onset of the coronavirus. “I’ve received more questions about things I know are misinformation,” he says, such as the efficacy of hydroxychloroquine to treat COVID-19 and whether face masks really prevent the virus’s spread.
Brenda Linares, health sciences librarian at University of Kansas Medical Center School of Nursing in Kansas City, says she has seen similar misinformation in the Latinx community. Linares hosted a webinar on the topic last August and has frequently discussed health literacy as it relates to the coronavirus in her bimonthly Spanish-language podcast Juntos Radio.
Linares says that since the onset of the pandemic, she had seen a number of English-language podcasts on COVID-19 but not many in Spanish—so she decided to launch Juntos Radio in March 2020. “I thought it would be great to share those resources,” she says. The podcast’s first episode provided COVID‑19 prevention tips; subsequent pandemic-related episodes have dealt with social-distancing best practices and debunking vaccine myths. The podcast has also covered childhood obesity, Alzheimer’s disease, and other topics.
She notes that health literacy is one of the social determinants of health, which include factors such as socioeconomic status and education. Those who don’t understand their options for accessing health care will suffer as a result, she says.
Bringing webinars to your community
Daly hosted more than 40 webinars on topics related to the pandemic for Orlando Health in 2020. She recommends that health librarians hoping to offer similar programs—related to COVID-19 or not—start by sticking to the basics and turning to colleagues for assistance.
“The best thing to do is connect with others who are already doing it,” she says. In her view, asking health literacy professionals—as well as nurses, doctors, and others in your organization—for advice and best practices is crucial. They can offer guidance on content as well as on recording and promoting the webinar. Medical professionals can even be guests on your webinar, she says.
But it’s important to remember that librarians themselves cannot give medical advice: “The consumer health librarian’s responsibility is to provide credible and timely health information,” she says. “Once the patient receives [that] information, it is their responsibility to share it with their physician or medical professional team.”
Even more important, Daly says, is connecting with the community to assess its wants and needs. COVID‑19 remains a huge concern, she says, but people are dealing with other medical issues as well. Daly keeps a list of health care questions that patients pose to her—a list that has led to webinars on cancer prevention, medication safety, planning for an effective doctor’s visit, preparing for surgery, and other topics.
“You don’t need to reinvent the wheel,” Daly says. “But you want to put your own spin on [your webinar] and make it personalized for your area and your participants.”