Each year, some 9,500 premature infants die in Tanzania. This high neonatal mortality rate has remained unchanged for decades in this low-resource country. Among the major causes of death are birth asphyxia, respiratory failure, and infections. Tanzania has limited capacity to monitor either heart rate or respiration continuously and manage preterm infants with respiratory distress with any breathing support other than oxygen. Also, antibiotics are only initiated when the preterm infant becomes symptomatic, which is too late to intervene.
Faced with these sobering facts, Jeffrey M. Perlman, MB, ChB, Chief of the Division of Newborn Medicine, Komansky Children’s Hospital at NewYork-Presbyterian/Weill Cornell Medical Center, has marshaled efforts to facilitate a low-cost, evidence-based preventative strategy to combat infant mortality in the developing world.
“I’ve been working in global health in Tanzania for about 12 years now,” says Dr. Perlman, a world-renowned expert in neonatal medicine. “We published a paper in 2013 in which we showed that by using a very simple educational program called Helping Babies Breathe, we were able to reduce mortality by 47 percent and, surprisingly, reduce stillbirths by 24 percent.”
Helping Babies Breathe, an initiative of the American Academy of Pediatrics in collaboration with the World Health Organization, and a number of other global health stakeholders, teaches healthcare workers in low-resource countries the basic techniques to resuscitate babies immediately after birth. “We were the first to publish on this and there have been numerous papers that have replicated our findings,” says Dr. Perlman.
Dr. Jeffrey M. Perlman and some of the research team members in Tanzania
Since then Dr. Perlman has targeted his efforts to save premature infants at 28 to 34 6/7 weeks estimated gestational age via the pilot implementation of a Premature Care Bundle. The bundle was tested at four Tanzania hospitals between July 2015 and June 2016 and includes:
- administration of antenatal corticosteroids to mothers in preterm labor to facilitate lung maturation;
- administration of antibiotics to mothers when in active labor;
- immediate stabilization/resuscitation of the newborn, including avoidance of a drop in body temperature <36° C; and
- administration of early neonatal antibiotics.
The care bundle reflected standard interventions undertaken in the United States. “This whole care bundle that we have developed costs less than $7 per medication for both mother and baby,” says Dr. Perlman. “That’s about the cost of a large latté at Starbucks.”
“I’ve established a core group of investigators — all Tanzanians — at three university-affiliated hospitals and one district hospital that conduct research,” continues Dr. Perlman, who facilitated implementation of the care bundle.
The pre- versus post-implementation findings of the study, which were just published in the March 2018 issue of PloS One, saw an overall 26 percent reduction in neonatal mortality from 166/1,000 to 122/1,000 live births, and a 33 percent reduction in fresh stillbirths from 162/1,000 to 111/1,000. “By subgroup analysis, when we looked at the babies, 28 to 30 6/7 weeks, there was no reduction in mortality,” notes Dr. Perlman. “However, when we looked at the ‘bigger babies,’ i.e., 31 to 34 6/7 weeks, there was a 45 percent reduction.”
Dr. Perlman emphasizes that interventions that used a combination of medications, for example, steroids and neonatal antibiotics versus none, achieved a 70 percent reduction in mortality. “When steroids were used alone, it was associated with a non-significant increase in neonatal mortality, a finding similar to that reported previously in the low-resource setting,” he says. “We speculate this is because neonatal antibiotics weren’t used, which we think is extremely important. Babies at a lower temperature died more frequently compared to the survivors.”
At full implementation of the program, Dr. Perlman believes that some 4,000 lives can be saved each year in Tanzania. “This care bundle serves as a bridge between events during labor and the first postnatal ‘Golden Hour.’ Thereafter, other programs such as Essential Newborn Care and Saving Newborn Lives should be implemented.”
“The rewards for me are twofold. The first obviously relates to the positive outcomes, and the second relates to the development of a core group of Tanzanian investigators,” adds Dr. Perlman. “We have had spectacular results and that is attributed to the people on the ground. If these findings can be replicated in other resource-limited settings, the ability to further reduce the less than five-year mortality rates becomes enormous.”