Hellebores from the Van Dusen Garden. Will a changing climate mean more such plants growing in Calgary?
Based on climate data collected from 1981 to 2010 and the resultant map published in 2014, much of Calgary now lies in plant hardiness zone 4a. The map we’re probably most familiar with was produced using data from 1961 to 1990 and published in 2001.
We are not going to see immediate and great changes in native plant types as a result of warming trends, but it does mean we can be more adventurous in our plant selection. At first this sounds like heaven — but not quite. Trees bud out earlier than fifty years ago, but as we know from May this year, the dates of late frosts have not changed as much, so fruit tree and shrub blossoms may still suffer from late frosts and pollinators may not be present at just the right time.
What do we mean by hardiness zones? We can use two different definitions. The simplest is that published by the U.S. Department of Agriculture, based solely on the extreme minimum temperature of the coldest day of the year, but this disregards precipitation. The second is the more sophisticated, Canadian, method that takes seven variables into consideration, including minimum daily and monthly temperatures and precipitation.
One difficulty for us is that growers’ plant labels often don’t state which of these two systems have been used and they can be different: the U.S. version for instance shows Lethbridge in zone 4a, whereas the Canadian one shows it as 4b (warmer). However, both the U.S. and the Canadian methods demonstrate the warming of Western Canada’s weather, typically changing more than a zone over that fifty year period ending in 2010. On average in Canada, the areas covered by zones 3 and 4 have expanded by about 200 per cent, and the average frost-free days have increased by 11 days.
A third process is being developed that using data from specific plants, and which produces maps that indicate which plants should survive. The government website reports the distribution of some 3,000 North American plant species, and provides a listing of plants that grow in various geographic areas. Data from 62 northern tree species shows Canadian climate “envelopes” (i.e. plant distribution maps) have moved an average of 57 kilometres northward since the middle of the last century, and this is particularly marked west of Manitoba.
Several characteristics of Calgary’s climate have changed, including the number of consecutive frost-free days during our growing season. For the thirty years ending in 2010, the last frost typically occurred on May 21 and the first fall frost on Sept. 16, giving an average of 117 consecutive frost-free days. In the 20th century, occasionally killing frosts (-2 C or below) occurred as late as June, but this is no longer the case, at least at the airport. The number of “growing degree-days” (usually calculated as the difference between the mean temperature and 5 C, multiplied by the number of those warm days) has had a big increase to 1,448 days. The average precipitation has also increased to 419 millimetres (16 inches). Extremes seem to be changing, as seen in the floods of June 2013, but the recorded daily maximum rainfall was in fact in 1927, and the highest temperature was recorded back in July 1919.
The previous Government of Canada plant hardiness zone map, published in 2001, showed Calgary to be generally in zone 3a; the new 2014 version shows us to be in 4a. In general plants — and bugs — remain more prolific in the southeast parts of Calgary, particularly on the flood plain of the Bow River valley, while in our higher western and northwestern areas, both need to be tougher to survive.
A potential change is the number of days that winter insulating snow will cover our perennials. Time will tell whether our gardens have more Christmas roses (hellebores), butterflies and bigger slugs … or perhaps more succulents and grasshoppers: I’m hoping for more butterflies and a greater variety of birds!
Glynn Wright, Calgary Horticultural.