Why Small Business Must Compete on Compensation in 2015
By: John Rossheim
Small businesses enjoyed something of a compensation honeymoon in the years following the 2007-2009 recessionary years. Workers were so relieved to stay employed or to get any kind of job offer that many never considered bargaining for more.
But the honeymoon may be over.
Today, growing companies must learn to compete for talent with companies of all sizes, everywhere in the world, in all arenas, including employee compensation. Here's a roundup of small business compensation trends and challenges for 2015.
Inequitable pay can be toxic. Inequity in pay can be particularly destructive to employee morale and loyalty in small firms where it's hard to keep secrets.
“Companies definitely should be concerned about pay equity, but this often gets neglected," says Elissa Tucker, research program manager for human capital management at business research nonprofit APQC. "People will get disengaged quickly if new hires come in at a significantly higher rate. This is easy to overlook.”
Fixed pay, high attrition? Performance-based compensation, long popular for most businesses of any size, is, in 2015, a virtual necessity. Still, some 28 percent of small companies do not offer variable pay incentives, according to the PayScale 2015 Compensation Best Practices report.
Why? "Small business owners have a lot of balls in the air -- they may not thinking holistically about the elements of pay," says Tim Low, Vice President of Marketing at consulting firm Payscale.
"Small businesses worry more about the risks of variable pay, but it's the market trend." In the past, this has meant the average salary at many small companies has lagged in relation to the overall market. Of course, failing to pay for performance raises another risk: attrition of top performers.
Variable pay: Ever broader and deeper. In 2015, it's not enough to offer to performance-based pay to just a few top managers. "Variable pay has been broadened to include all employees in many organizations," says Ken Abosch, a partner with consulting firm Aon Hewitt. "Average variable pay has reached a record high level of 12 percent of total pay."
Which variable-pay schemes are winning? Small businesses often gravitate to the simplest kind of performance bonuses: spot bonuses granted spontaneously for a job well done this month or even today. But such bonuses may not align well with the company's long-term strategy, and they can appear arbitrary.
There are superior options, though they require more work to implement. "Individual performance bonuses for reaching specific goals are very popular," says Abosch. "The most popular performance-based bonus rewards a mix of company, business unit and individual achievements."
Company owners may not make the best compensation managers. With competition for talent heating up, small-business chiefs should consider getting expert advice on their compensation plans. Because when owners set pay on their own, " 'intuitively' would be the diplomatic word for how they do it," says Tim Low at PayScale. "The personality type is not afraid to dive in."
Some 52 percent of small-company chiefs set pay structures themselves, according to PayScale's 2015 Compensation Best Practices report. Larger companies are more likely to have a human resources manager or executive with expertise in compensation.
Small companies win big talent with bigger money. Small business can win against larger ones in talent skirmishes -- if they've got the payroll budget. "In the last five to eight years, Atlanta has seen a group of more entrepreneurial, very profitable organizations that are keeping their people ahead of the comp curve," says Frank Green, president of search firm ExecuSearch.
Green is currently working with two candidates interviewing for jobs at smaller companies: one could land a $16,000 increase for a position in healthcare finance; the other is campaigning for a senior accounting role that would come with a $40,000 raise.
Total compensation statements: High value, low cost. Often overlooked, individualized total compensation statements, distributed to all employees annually, are a wise (and inexpensive) way to remind staff that their compensation is more than just the "net pay" line on the pay stub.
"Total compensation statements help management communicate the full value of what you’re giving them," says Low. "The ability to enumerate all the elements may open employees’ eyes to the value of healthcare, dental, and vision insurance, and so on.” According to PayScale’s 2015 compensation survey, 58 percent of respondents reported that they do not offer them.
Payroll alert for 2016: Health insurance requirement. Under the Affordable Care Act, if your business has between 50 and 99 employees or reaches that headcount in 2015, you'll be required to provide health insurance to full-time workers in 2016, or pay a tax penalty. (Unless this requirement is postponed, again.)
In any case, if you don't insure your workers now, start planning for this major payroll expense and think about how you can leverage that investment to attract better workers -- and retain employees.